% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.stratafit.R
\name{summary.stratafit}
\alias{summary.stratafit}
\title{Summarizes a fitted spatial linear model with a stratification variable..}
\usage{
\method{summary}{stratafit}(object, ...)
}
\arguments{
\item{object}{is an object generated from \code{\link{slmfit}()} of class \code{slmfit}.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
a list with \itemize{
  \item model formula
  \item a table of fixed effects estimates and associated standard errors
  \item estimated spatial covariance parameter estimates
  \item residuals
  \item generalized r-squared.
       }
}
\description{
If a model is fitted with \code{\link{stratafit}()}, then
this summary function produces summary output for each level
of the stratification variable in the same style as the
\code{\link{summary.slmfit}()} function.
}
\examples{
data(exampledataset) ## load a toy data set
exampledataset$strata <- c(rep("A", 25), rep("B", 15))
strataobj <- stratafit(formula = counts ~ pred1 + pred2,
 data = exampledataset, stratacol = "strata",
xcoordcol = 'xcoords', ycoordcol = 'ycoords', areacol = 'areavar')
summary(strataobj)
}
