% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.predict.slmfit.R
\name{print.predict.slmfit}
\alias{print.predict.slmfit}
\title{Prints a short summary for the \code{\link{predict.slmfit}()} function.}
\usage{
\method{print}{predict.slmfit}(x, digits = max(3L, getOption("digits") - 3L), ...)
}
\arguments{
\item{x}{is a prediction object generated from \code{\link{predict.slmfit}()}}

\item{digits}{is the number of digits to be displayed in the
model output}

\item{...}{further arguments passed to or from other methods.}
}
\description{
This function uses the object that is output from \code{\link{predict.slmfit}()} of class \code{predict.slmfit}.
}
\examples{
data(exampledataset) ## load a toy data set
slmobj <- slmfit(formula = counts ~ pred1 + pred2, data = exampledataset,
xcoordcol = 'xcoords', ycoordcol = 'ycoords', areacol = 'areavar')
print(predict(slmobj), digits = 4)
}
