% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inputs.R
\name{textInputGroup}
\alias{textInputGroup}
\title{Bootstrap 3 text input group}
\usage{
textInputGroup(
  textId,
  label = "",
  value = "",
  placeholder = "enter text",
  left_text = NULL,
  right_text = NULL,
  style = "width: 100\%;"
)
}
\arguments{
\item{textId}{text box id}

\item{label}{text label for this input group}

\item{value}{default value for the text input}

\item{placeholder}{default placeholder text for the text input if no value}

\item{left_text}{text or icon add to the left side}

\item{right_text}{text or icon add to the right side}

\item{style}{additional style add to the group}
}
\value{
text input group component
}
\description{
Text input group and custom widgets append to left ar/and right
}
\details{
If no text is specified for both left and right, the return is almost
identical to \link{clearableTextInput}
}
\examples{
if(interactive()){

    ui <- fluidPage(
        textInputGroup("id1", "left", left_text = "a"),
        textInputGroup("id2", "right", right_text = "b"),
        textInputGroup("id3", "both", left_text = "$", right_text = ".00"),
        textInputGroup("id4", "none"),
        textInputGroup("id5", "icon", left_text = icon("home")),
    )

    server <- function(input, output, session) {

    }

    shinyApp(ui, server)
}
}
