% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inputs.R
\name{clearableTextInput}
\alias{clearableTextInput}
\title{A clearable text inputInput control}
\usage{
clearableTextInput(
  inputId,
  label = "",
  value = "",
  placeholder = "",
  style = "width: 100\%;"
)
}
\arguments{
\item{inputId}{ID}

\item{label}{text label above}

\item{value}{default value}

\item{placeholder}{place holder text when value is empty}

\item{style}{additional CSS styles you want to apply}
}
\value{
a shiny component
}
\description{
An UI component with a "X" button in the end to clear the entire
entered text. It works the same as \code{Textinput}.
}
\examples{
if(interactive()){

    ui <- fluidPage(
        clearableTextInput("input1", "This is a input box", style = "width: 50\%;"),
        verbatimTextOutput("out1")
    )

    server <- function(input, output, session) {
        output$out1 <- renderPrint(input$input1)
    }

    shinyApp(ui, server)
}
}
