% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{PermutationCorr}
\alias{PermutationCorr}
\title{Permutation based p-value for Pearson's correlation coefficient}
\usage{
PermutationCorr(x, y, R = 999, seed = 1, return.permutation = FALSE)
}
\arguments{
\item{x}{A numerical vector with the first variable.}

\item{y}{A numerical vector with the second variable.}

\item{R}{The number of permutations to be conducted, set to 999 by default.}

\item{seed}{Random seed used. Default is 1.}

\item{return.permutation}{Return permutations. Default is \code{FALSE}.}
}
\value{
A list containing the following:
\itemize{
\item correlation, Pearson's correlation coefficient.
\item p.val, permutation based p-value.
\item return.permutation, permutation used if returned.
}
}
\description{
Calculate permutation based p-value for Pearson's correlation coefficient.
}
\details{
It's adapted from \code{permcor} function in \href{https://cran.r-project.org/package=Rfast}{Rfast} with corrections in calculating the number of permutations and the p-values.
}
\examples{
{
x <- iris[, 1]
y <- iris[, 2]
res <- PermutationCorr(x, y, R = 9999)
}

}
\concept{stats}
