% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fire_mov.R
\name{plot_fire_mov}
\alias{plot_fire_mov}
\title{Plotting the fire movement}
\usage{
plot_fire_mov(
  result,
  cluster = "all",
  hotspot = TRUE,
  from = NULL,
  to = NULL,
  step = 1,
  bg = NULL
)
}
\arguments{
\item{result}{\code{spotoroo} object. A result of a call to \code{\link[=hotspot_cluster]{hotspot_cluster()}}.}

\item{cluster}{Character/Integer. If "all", plot all clusters. If an integer
vector is given, plot corresponding clusters.}

\item{hotspot}{Logical. If \code{TRUE}, plot the hot spots.}

\item{from}{\strong{OPTIONAL}. Date/Datetime/Numeric. Start time. The data type
needs to be the same as the provided observed time.}

\item{to}{\strong{OPTIONAL}. Date/Datetime/Numeric. End time. The data type
needs to be the same as the provided observed time.}

\item{step}{Integer (>0). Step size used in the calculation of the
fire movement.}

\item{bg}{\strong{OPTIONAL}. \code{ggplot} object. If specified, plot onto this object.}
}
\value{
A \code{ggplot} object. The plot of the fire movements.
}
\description{
This function plots the fire movement. The fire movement is calculated
from \code{\link[=get_fire_mov]{get_fire_mov()}}.
}
\examples{
\donttest{

  # Time consuming functions (>5 seconds)


  # Get clustering results
  result <- hotspot_cluster(hotspots,
                          lon = "lon",
                          lat = "lat",
                          obsTime = "obsTime",
                          activeTime = 24,
                          adjDist = 3000,
                          minPts = 4,
                          minTime = 3,
                          ignitionCenter = "mean",
                          timeUnit = "h",
                          timeStep = 1)

  # Plot cluster 1 to 4
  plot_fire_mov(result, cluster = 1:4)

  # Plot cluster 1 to 4, set step = 6
  plot_fire_mov(result, cluster = 1:4, step = 6)
}

}
