% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/playlists.R
\name{get_playlist_cover_image}
\alias{get_playlist_cover_image}
\title{Get Image Associated with Playlist}
\usage{
get_playlist_cover_image(
  playlist_id,
  authorization = get_spotify_authorization_code()
)
}
\arguments{
\item{playlist_id}{Required. The \href{https://developer.spotify.com/documentation/web-api/#spotify-uris-and-ids}{Spotify ID} for the playlist.}

\item{authorization}{Required. A valid access token from the Spotify Accounts service.
See the \href{https://developer.spotify.com/documentation/general/guides/authorization-guide/}{Web API authorization Guide} for more details. Defaults to \code{spotifyr::get_spotify_authorization_code()}. The access token must have been issued on behalf of the current user. \cr
Current playlist image for both Public and Private playlists of any user are retrievable on
provision of a valid access token.}
}
\value{
Returns a data frame of results containing playlist cover image information.
See the official
\href{https://developer.spotify.com/documentation/web-api/reference/playlists/get-playlist-cover/}{Spotify Web API Documentation} for more information.
}
\description{
Get the current image associated with a specific playlist.
}
