% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_user_audio_features.R
\name{get_user_audio_features}
\alias{get_user_audio_features}
\title{Get features and popularity for all of a user's playlists on Spotify}
\usage{
get_user_audio_features(username, access_token = get_spotify_access_token())
}
\arguments{
\item{username}{String of Spotify username. Can be found on the Spotify app. (See http://rcharlie.net/sentify/user_uri.gif for example)}

\item{access_token}{Spotify Web API token. Defaults to spotifyr::get_spotify_access_token()}
}
\description{
This function returns the popularity and audio features for every song for all of a given user's playlists on Spotify
}
\examples{
\dontrun{
obama_track_features <- get_user_audio_features('barackobama')
}
}
\keyword{audio}
\keyword{features}
\keyword{playlists}
\keyword{track}
