% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/latex.R
\name{as_latex.spar}
\alias{as_latex.spar}
\title{Convert One Spork to Latex}
\usage{
\method{as_latex}{spar}(x, newline = getOption("latex_newline", "\\n"),
  unrecognized = getOption("latex_unrecognized", "latexToken"),
  token_open = getOption("latex_token_open", "\\\\textrm{"),
  token_close = getOption("latex_token_close", "}"),
  math_open = getOption("latex_math_open", "\\\\mathrm{"),
  math_close = getOption("latex_math_close", "}"),
  label_open = getOption("latex_label_open", "$"),
  label_close = getOption("latex_label_close", "$"),
  enforce_math = getOption("latex_enforce_math", TRUE), ...)
}
\arguments{
\item{x}{spar}

\item{newline}{value to replace \code{'\\n'}}

\item{unrecognized}{function to process unrecognized tokens: default \code{\link{latexToken}}}

\item{token_open, token_close}{these wrap text-like portions of the label; the defaults try to give upright characters (non-italic); also passed to \code{\link{latexToken}}}

\item{math_open, math_close}{these wrap math-like portions of the label;  the defaults try to give upright characters (non-italic) which may not work for Greek symbols; also passed to \code{\link{latexToken}}}

\item{label_open, label_close}{these wrap the entire label; defaults invoke traditional math mode}

\item{enforce_math}{whether to enforce math mode for nested expression: \code{\link{latexToken}}}

\item{...}{passed to \code{unrecognized}; see \code{\link{latexToken}}}
}
\value{
latex
}
\description{
Converts one spork to latex.
See description for \code{\link{as_spork}}.
By default, unrecognized tokens are returned
literally.  However, Greek symbols and latex
metacharacters are escaped.
See \code{\link{latexToken}}.
}
\details{
Experimental support is implemented for
the newline character (\code{'\\n'}).
Default behavior is to introduce literal
newline characters into the resulting
tex.  This may have no effect on the
typeset result. It may be possible
to achieve other effects by using
non-default values of helper arguments
and perhaps additional latex packages.
}
\examples{
library(magrittr)
'V_c./F' \%>\% as_spork \%>\% as_latex
'AUC_ss' \%>\% as_spork \%>\% as_latex
'C_max_ss' \%>\% as_spork \%>\% as_latex
'var^eta_j' \%>\% as_spork \%>\% as_latex
'& \% $ # \\\\_ { } ~ \\\\^ \\\\' \%>\% as_spork \%>\% as_latex
'one joule (Omega) ~ 1 kg*m^2./s^2' \%>\% as_spork \%>\% as_latex
}
\seealso{
Other interface: \code{\link{as.expression.plotmath}},
  \code{\link{as_latex.spork}},
  \code{\link{as_plotmath.spar}},
  \code{\link{as_plotmath.spork}},
  \code{\link{as_previews.spork}},
  \code{\link{as_spork.character}},
  \code{\link{latexToken}}, \code{\link{plotmathToken}}

Other latex: \code{\link{[.latex}}, \code{\link{[[.latex}},
  \code{\link{as_latex.spork}}, \code{\link{as_latex}},
  \code{\link{concatenate.latex}}, \code{\link{latexToken}}
}
\concept{interface}
\concept{latex}
