% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/occ2df.R
\name{occ2df}
\alias{occ2df}
\title{Combine results from occ calls to a single data.frame}
\usage{
occ2df(obj, what = "data")
}
\arguments{
\item{obj}{Input from occ, an object of class \code{occdat}, or an object
of class \code{occdatind}, the individual objects from each source within the
\code{occdat} class.}

\item{what}{(character) One of data (default) or all (with metadata)}
}
\description{
Combine results from occ calls to a single data.frame
}
\details{
This function combines a subset of data from each data provider to a single
data.frame, or metadata plus data if you request \code{what="all"}. The
single data.frame contains the following columns:
\itemize{
\item name - scientific (or common) name
\item longitude - decimal degree longitude
\item latitude - decimal degree latitude
\item prov - data provider
\item date - occurrence record date
\item key - occurrence record key
}
}
\examples{
\dontrun{
# combine results from output of an occ() call
spnames <- c('Accipiter striatus', 'Setophaga caerulescens',
  'Spinus tristis')
out <- occ(query=spnames, from='gbif', gbifopts=list(hasCoordinate=TRUE),
  limit=10)
occ2df(out)
occ2df(out$gbif)

out <- occ(
  query='Accipiter striatus',
  from=c('gbif','ebird','inat'),
  gbifopts=list(hasCoordinate=TRUE), limit=2)
occ2df(out)
occ2df(out$gbif)

# or combine many results from a single data source
spnames <- c('Accipiter striatus', 'Spinus tristis')
out <- occ(query=spnames, from='gbif', limit=2)
occ2df(out$gbif)
}
}
