% Generated by roxygen2 (4.0.0): do not edit by hand
\name{mapleaflet}
\alias{mapleaflet}
\title{Make an interactive map to view in the browser}
\usage{
mapleaflet(data, popup = TRUE, map_provider = "osm", zoom = 3,
  title = "map", size, centerview = c(30, -73.9), dest = ".",
  overwrite = TRUE, incl.data = TRUE)
}
\arguments{
\item{data}{A data.frame, with any number of columns, but with at least the
following: name (the taxonomic name), latitude (in dec. deg.), longitude
(in dec. deg.)}

\item{popup}{If TRUE (default) popup tooltips are created for each point with
metadta for that point.}

\item{map_provider}{Base map to use. One or a list of 'osm' (OpenStreetMap
standard map), 'tls' (Thunderforest Landscape), 'cm' (CloudMade), 'mqosm'
(MapQuest OSM) or 'mqsat' (MapQuest Open Aerial). Default is 'osm'. See
\code{\link[leafletR]{leaflet}} for more information.}

\item{zoom}{Map zoom, 0 being most zoomed out, and 18 most zoomed out. See
\code{\link[leafletR]{leaflet}} for more information.}

\item{size}{Height and width (in pixels) of map as a length 2 vector. If missing,
a fullscreen (browser window) map is generated.}

\item{centerview}{Lat/long position to center map}

\item{dest}{Specify a path to save an html file of your map. You can open this
in your browser to view it. If left as NULL (the default) the map opens up in
your default browser, or if you have a newer version of RStudio open in RStudio
Viewer pane.}

\item{overwrite}{Default is \code{TRUE}. Set to \code{FALSE} to prevent overwriting local files}

\item{incl.data}{Default is \code{TRUE}. Writes geoJSON data into the html file to get around security restrictions in browsers like Google Chrome. Set to \code{FALSE} to read from a separate local geoJSON file.}

\item{title}{Map title}
}
\description{
Make an interactive map to view in the browser
}
\details{
NOTE that with some map_provider options you will have no map layer
   show up at first. This may be because there is no map at that particular
   zoom level. Just zoom in or out to see the map.
}
\examples{
\dontrun{
spp <- c('Danaus plexippus','Accipiter striatus','Pinus contorta')
dat <- occ(query = spp, from = 'gbif', gbifopts = list(hasCoordinate = TRUE))
data <- occ2df(dat)
mapleaflet(data = data, dest = ".")

# An example with more species, a different base map, and different color palette
spp <- c('Danaus plexippus','Accipiter striatus','Pinus contorta','Puma concolor',
'Ursus americanus','Gymnogyps californianus')
dat <- occ(query = spp, from = 'gbif', gbifopts = list(hasCoordinate = TRUE))
data <- occ2df(dat)
mapleaflet(data, map_provider = 'toner')
}
}

