% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spm12_contrast.R
\name{spm12_contrast}
\alias{spm12_contrast}
\alias{spm12_contrast_list}
\title{Build contrasts for SPM12 first level model}
\usage{
spm12_contrast(
  name,
  weights,
  replicate = c("none", "repl", "replsc", "sess", "both", "bothsc")
)

spm12_contrast_list(cons, type = "T")
}
\arguments{
\item{name}{Name of the contrast}

\item{weights}{Weights of the contrast, 
must be the same length as the number of regressors}

\item{replicate}{If  there  are  multiple  sessions with 
identical conditions, one might want to specify contrasts 
which are identical over sessions. Options are 
no replication (\code{none}), 
replicate (\code{repl}), 
replicate + scale (\code{replsc}), 
create per session (\code{sess}), 
Both: Replicate + Create per session (\code{both}), 
Both: Replicate + Scale + Create per session (\code{bothsc})}

\item{cons}{List of contrasts}

\item{type}{type of contrast, T-statistic or F-statistic}
}
\value{
A list of objects, each with a \code{name} and \code{value}
}
\description{
Build contrasts for SPM12 first level model
}
\examples{
res = spm12_contrast(name = "condition1", weights = c(
1, rep(0, 8)))
print(res)
contrasts = list(
list(name = "LeftHand",
       weights = c(1, rep(0, 7)),
replicate = "none",
type = "T" ),
list(name = "RightHand",
weights = c(0, 1, rep(0, 6)),
replicate = "none",
type = "T"), 
list(name = "AllEffects",
weights = rbind(
c(1, rep(0, 7)),
         c(0, 1, rep(0, 6))
       ),
replicate = "none",
type = "F")   
)
res = spm12_contrast_list(contrasts)
print(res)
}
