% Generated by roxygen2 (4.0.2): do not edit by hand
\name{cSplit}
\alias{cSplit}
\title{Split Concatenated Values into Separate Values}
\usage{
cSplit(indt, splitCols, sep = ",", direction = "wide", fixed = TRUE,
  drop = TRUE, stripWhite = FALSE, makeEqual = NULL)
}
\arguments{
\item{indt}{The input \code{data.frame} or \code{data.table}.}

\item{splitCols}{The column or columns that need to be split.}

\item{sep}{The values that serve as a delimiter \emph{within} each column.
This can be a single value if all columns have the same delimiter, or a
vector of values \emph{in the same order as the delimiters in each of the
\code{splitCols}}.}

\item{direction}{The desired direction of the results, either \code{"wide"}
or \code{"long"}.}

\item{fixed}{Logical. Should the split character be treated as a fixed
pattern (\code{TRUE}) or a regular expression (\code{FALSE})? Defaults to
\code{TRUE}.}

\item{drop}{Logical. Should the original concatenated column be dropped?
Defaults to \code{TRUE}.}

\item{stripWhite}{Logical. If there is whitespace around the delimiter in
the concatenated columns, should it be stripped prior to splitting? Defaults
to \code{FALSE}.}

\item{makeEqual}{Logical. Should all groups be made to be the same length?
Defaults to \code{FALSE}.}
}
\value{
A \code{\link[data.table:data.table]{data.table}} with the values
split into new columns or rows.
}
\description{
The \code{cSplit} function is designed to quickly and conveniently split
concatenated data into separate values.
}
\note{
The \code{cSplit} function replaces most of the earlier
\code{concat.split*} functions. The earlier functions remain for
compatability purposes, but now they are essentially wrappers for the
\code{cSplit} function.

If you know that all values in the column would have the same number of values per row after being split, you should use the \code{\link{cSplit_f}} function instead, which uses \code{\link[data.table:fread]{fread}} instead of \code{\link{strsplit}} and is generally faster.
}
\examples{
## Sample data
temp <- head(concat.test)

## Split the "Likes" column
cSplit(temp, "Likes")

## Split the "Likes" and "Hates" columns --
##   they have different delimiters...
cSplit(temp, c("Likes", "Hates"), c(",", ";"))

## Split "Siblings" into a long form...
cSplit(temp, "Siblings", ",", direction = "long")

## Split "Siblings" into a long form, removing extra whitespace
cSplit(temp, "Siblings", ",", direction = "long", stripWhite = TRUE)

## Split a vector
y <- c("a_b_c", "a_b", "c_a_b")
cSplit(as.data.table(y), "y", "_")
}
\author{
Ananda Mahto
}
\seealso{
\code{\link{concat.split}}, \code{\link{cSplit_f}}
}

