% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/custom_rpart_fns.R
\name{spline_eval}
\alias{spline_eval}
\title{Custom rpart eval function.}
\usage{
spline_eval(y, wt = NULL, parms = NULL)
}
\arguments{
\item{y}{the responses at this node, which will be estimated spline coefficients for individuals in the node.}

\item{wt}{Used to weight observations differently. Required by rpart, but not supported by splinetree, so its value will always be NULL.}

\item{parms}{rpart's custom split functionality allows optional parameters to be passed through the splitting functions.
In the splinetree package, the parms parameter is used to hold a list of length 1 or 2 containing either just a spline basis matrix (for a tree), or
a spline basis matrix and the probability that a variable will be selected at a split (for a random forest).}
}
\value{
A description for the node. This description includes the label, which is the mean response at the node,
and the deviance, which in this case is the total projected sum of squares.
}
\description{
The eval function is required for custom rpart functionality. The split criterion is the total sum of squared errors of the projected or smoothed outcome values around their mean.
Note that this is the node purity measure introduced by Yu and Lambert, 1999.
The calling of this function is always handled internally by rpart; the user will never directly call this function.
}
\keyword{internal}
