% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict}
\alias{predict}
\alias{predict.bSpline2}
\alias{predict.ibs}
\alias{predict.dbs}
\alias{predict.mSpline}
\alias{predict.iSpline}
\alias{predict.cSpline}
\title{Evaluate a Spline Basis}
\usage{
\method{predict}{bSpline2}(object, newx, ...)

\method{predict}{ibs}(object, newx, ...)

\method{predict}{dbs}(object, newx, ...)

\method{predict}{mSpline}(object, newx, ...)

\method{predict}{iSpline}(object, newx, ...)

\method{predict}{cSpline}(object, newx, ...)
}
\arguments{
\item{object}{Objects of class \code{bSpline2}, \code{ibs}, \code{mSpline},
\code{iSpline}, or \code{cSpline} having attributes describing
\code{knots}, \code{degree}, etc.}

\item{newx}{The \code{x} values at which evaluations are required.}

\item{...}{Optional argument for future usage.}
}
\value{
An object just like the \code{object} input, except evaluated at
the new values of \code{x}.
}
\description{
This function evaluates a predefined spline basis at (new) given values.
}
\details{
These are methods for the generic function \code{predict} for objects
inheriting from class \code{bSpline2}, \code{ibs}, \code{mSpline},
\code{iSpline}, or \code{cSpline}.  If \code{newx} is not given, the
function returns the input object.  For object returned by function
\code{\link{cSpline}}, the \code{mSpline} and \code{iSpline} objects shipped
in attributes should not be evaluated by this function if \code{rescale} is
\code{TRUE}.  See \code{\link{cSpline}} for details.
}
\examples{
library(splines2)
x <- seq.int(0, 1, 0.2)
knots <- c(0.3, 0.5, 0.6)
newX <- seq.int(0.1, 0.9, 0.2)

## for B-splines
bsMat <- bSpline(x, knots = knots, degree = 2)
predict(bsMat, newX)

## for integral of B-splines
ibsMat <- ibs(x, knots = knots, degree = 2)
predict(ibsMat, newX)

## for derivative of B-splines
dbsMat <- dbs(x, knots = knots, degree = 2)
predict(dbsMat, newX)

## for M-spline
msMat <- mSpline(x, knots = knots, degree = 2)
predict(msMat, newX)

## for I-spline
isMat <- iSpline(x, knots = knots, degree = 2)
predict(isMat, newX)

## for C-spline
csMat <- cSpline(x, knots = knots, degree = 2)
predict(csMat, newX)
}
\seealso{
\code{\link{bSpline}} for B-splines;
\code{\link{ibs}} for integral of B-splines;
\code{\link{dbs}} for derivative of B-splines;
\code{\link{mSpline}} for M-splines;
\code{\link{iSpline}} for I-splines;
\code{\link{cSpline}} for C-splines.
}
