% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/9_data.r
\docType{data}
\name{BreastCancer}
\alias{BreastCancer}
\title{Wisconsin Breast Cancer Database}
\format{
A data frame with 675 observations of 8 numeric variables and
target factor \code{Class}.
\itemize{
\item Id, Sample code number
\item Cl.thickness, Clump thickness
\item Cell.size, Uniformity of cell size
\item Cell.shape, Uniformity of cell shape
\item Marg.adhesion, Marginal adhesion
\item Epith.c.size, Single Epthelial cell size
\item Bare.nuclei, Bare nuclei
\item Bl.cromatin, Bland chromatin
\item Normal.nucleoli, Normal Nucleoli
\item Mitoses, Mitoses
\item Class, Class of cancer, either "benign" or "malignant"
}
}
\source{
{J.W. Smith., el al. 1988. Using the ADAP learning algorithm to forecast the onset of diabetes mellitus. In Proceedings of the Symposium on Computer Applications and Medical Care (pp. 261--265). IEEE Computer Society Press.}

{mlbench, R package. F. Leisch & E. Dimitriadou, 2021. mlbench: Machine Learning Benchmark Problems} \url{https://CRAN.R-project.org/package=mlbench}
}
\usage{
BreastCancer
}
\description{
The objective is to identify each of a number of benign or malignant classes.
Samples arrive periodically as Dr. Wolberg reports his clinical cases. The
database therefore reflects this chronological grouping of the data. This
grouping information appears immediately below, having been removed from
the data itself. Each variable except for the first was converted into 11
primitive numerical attributes with values ranging from 0 through 10. Rows
with missing attribute values and duplicate rows removed.
}
\details{
This is a cleaned subset of \code{mlbench}'s \code{BreastCancer}.
See \code{help(BreastCancer, package = "mlbench")} for the original.

Replicating this dataset:\preformatted{require("mlbench")
data(BreastCancer)

raw <- BreastCancer
## rownumber index of 8 duplicate 16 incomplete rows
idx <- !duplicated(raw) & complete.cases(raw) 
d <- raw[idx, 3:10]
d <- apply(d, 2L, as.integer)
d <- data.frame(d, Class = as.factor(raw$Class[idx]))
BreastCancer <- d
## save(BreastCancer, file = "./data/BreastCancer.rda")
}
}
\examples{
library("spinifex")
str(spinifex::BreastCancer)
dat <- scale_sd(spinifex::BreastCancer[, 1:8])
clas <- spinifex::BreastCancer$Class

bas <- basis_pca(dat)
mv <- manip_var_of(bas)
mt <- manual_tour(bas, mv)

ggt <- ggtour(mt, dat, angle = .2) +
  proto_default(list(color = clas, shape = clas))
\dontrun{
animate_plotly(ggt)}
}
\keyword{datasets}
