% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_util.r
\name{basis_onpp}
\alias{basis_onpp}
\title{The basis of Orthogonal Locality Preserving Projection (OLPP)}
\usage{
basis_onpp(data, d = 2L, type = c("knn", sqrt(nrow(data))))
}
\arguments{
\item{data}{Numeric matrix or data.frame of the observations, coerced to matrix.}

\item{d}{Number of dimensions in the projection space.}

\item{type}{A vector specifying the neighborhood graph construction.
Expects; \code{c("knn", k)}, \code{c("enn", radius)}, or \code{c("proportion",ratio)}.
Defaults to \code{c("knn", sqrt(nrow(data)))}, nearest neighbors equal to the
square root of observations.}
}
\value{
Orthogonal matrix basis that distinguishes the levels of \code{class}
based on local and non-local variation as weighted against the neighborhood
graph.
}
\description{
Orthogonal Locality Preserving Projection (OLPP) is the orthogonal variant of
LPP, a linear approximation to Laplacian Eigenmaps. It finds a linear
approximation to the eigenfunctions of the Laplace-Beltrami operator on the
graph-approximated data manifold. For the more details on \code{type} see
\code{\link[Rdimtools:aux.graphnbd]{Rdimtools::aux.graphnbd()}}.
}
\examples{
dat_std <- scale_sd(wine[, 2:14])
basis_onpp(data = dat_std)
}
\references{
He X (2005). Locality Preserving Projections. PhD Thesis,
University of Chicago, Chicago, IL, USA.
}
\seealso{
\code{\link[Rdimtools:do.onpp]{Rdimtools::do.onpp}}

\code{\link[Rdimtools:aux.graphnbd]{Rdimtools::aux.graphnbd}} for
details on \code{type}.

Other basis identifiers: 
\code{\link{basis_guided}()},
\code{\link{basis_half_circle}()},
\code{\link{basis_odp}()},
\code{\link{basis_olda}()},
\code{\link{basis_pca}()}
}
\concept{basis identifiers}
