% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_util.r
\name{view_basis}
\alias{view_basis}
\title{Plot projection frame and return the axes table}
\usage{
view_basis(
  basis,
  data = NULL,
  lab = NULL,
  axes = "center",
  col = "black",
  pch = 20,
  cex = 1,
  alpha = 1
)
}
\arguments{
\item{basis}{A (p, d) orthonormal numeric matrix.
The linear combination the original variables contribute to projection space.
Required, no default.}

\item{data}{Optional (n, p) data to plot on through the projection basis.}

\item{lab}{Optional, labels for the reference frame of length 1 or the
number of variables used. By default will abbreviate data if available.}

\item{axes}{Position of the axes: "center", "bottomleft" or "off". Defaults
to "center".}

\item{col}{Color of the projected points. Defaults to "black".}

\item{pch}{Point character of the projected points. Defaults to 20.}

\item{cex}{Point size of the data. Defaults to 1.}

\item{alpha}{Opacity of the data points between 0 and 1. Defaults to 1.}
}
\value{
ggplot object of the basis.
}
\description{
Uses base graphics to plot the circle with axes representing
the projection frame. Returns the corresponding table.
}
\examples{
rb <- tourr::basis_random(4, 2)
view_basis(basis = rb)

flea_std <- tourr::rescale(tourr::flea[, 1:4])
view_basis(basis = rb, data = flea_std, axes = "bottomleft", 
           col = tourr::flea[, 7], pch = tourr::flea[,7])
}
