% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upscale.R
\name{upscale}
\alias{upscale}
\title{Upscaling of smooth components}
\usage{
upscale(f, x, y, wavelet = "haar", wtrafo = "dwt", pad = mean(f))
}
\arguments{
\item{f}{A vector.}

\item{x}{Corresponding x-coordinates which have to be integer.}

\item{y}{Corresponding y-coordinates which have to be integer.}

\item{wavelet}{Name of wavelet family. \code{haar}, \code{d4}, and \code{la8}.
are possible. \code{haar} is the default.}

\item{wtrafo}{Type of wavelet transform. Either \code{dwt} or \code{modwt}.
\code{dwt} is the default.}

\item{pad}{A numeric value for padding the matrix
into a bigger square. Default is set to mean(f).}
}
\value{
A set of plots showing the matrix image at each value for
\code{level}.
}
\description{
The analysis is based a wavelet multiresolution analysis
using only smooth wavelet components.
It is a 2D analysis taking the grid structure and provides scale-specific
results for data sampled on a contiguous geographical area. The
dataset is assumed to be regular gridded and the grid cells are
assumed to be square.
The scale-dependent results are graphically displayed.
}
\examples{
data(carlinadata)

# Upscaling of smooth components
upscale(carlinadata$land.use,carlinadata$x,carlinadata$y)
upscale(carlinadata$aridity,carlinadata$x,carlinadata$y,pad=0)

}
\author{
Gudrun Carl
}
