% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unif-alts.R
\name{F_from_f}
\alias{F_from_f}
\alias{F_inv_from_f}
\title{Distribution and quantile functions from angular function}
\usage{
F_from_f(f, p, Gauss = TRUE, N = 320, K = 1000, tol = 1e-06, ...)

F_inv_from_f(f, p, Gauss = TRUE, N = 320, K = 1000, tol = 1e-06, ...)
}
\arguments{
\item{f}{angular function defined on \eqn{[-1, 1]}. Must be vectorized.}

\item{p}{integer giving the dimension of the ambient space \eqn{R^p} that
contains \eqn{S^{p-1}}.}

\item{Gauss}{use a \link[=Gauss_Legen_nodes]{Gauss--Legendre quadrature}
rule to integrate \eqn{f} with \code{N} nodes? Otherwise, rely on
\code{\link{integrate}} Defaults to \code{TRUE}.}

\item{N}{number of points used in the Gauss--Legendre quadrature. Defaults
to \code{320}.}

\item{K}{number of equispaced points on \eqn{[-1, 1]} used for evaluating
\eqn{F^{-1}} and then interpolating. Defaults to \code{1e3}.}

\item{tol}{tolerance passed to \code{\link{uniroot}} for the inversion of
\eqn{F}. Also, passed to \code{\link{integrate}}'s \code{rel.tol} and
\code{abs.tol} if \code{Gauss = FALSE}. Defaults to \code{1e-6}.}

\item{...}{further parameters passed to \code{f}.}
}
\value{
A \code{\link{splinefun}} object ready to evaluate \eqn{F} or
\eqn{F^{-1}}, as specified.
}
\description{
Numerical computation of the distribution function \eqn{F} and
the quantile function \eqn{F^{-1}} for an \link[=locdev]{angular function}
\eqn{f} in a \link[=tang-norm-decomp]{tangent-normal decomposition}.
\eqn{F^{-1}(x)} results from the inversion of
\deqn{F(x) = \int_{-1}^x \omega_{p - 1}c_f f(z) (1 - z^2)^{(p - 3) / 2}
\,\mathrm{d}z}{F(x) = \int_{-1}^x \omega_{p - 1}c_f f(z)
(1 - z^2)^{(p - 3) / 2} dz}
for \eqn{x\in [-1, 1]}, where \eqn{c_f} is a normalizing constant and
\eqn{\omega_{p - 1}} is the surface area of \eqn{S^{p - 2}}.
}
\details{
The normalizing constant \eqn{c_f} is such that \eqn{F(1) = 1}. It does not
need to be part of \code{f} as it is computed internally.

Interpolation is performed by a monotone cubic spline. \code{Gauss = TRUE}
yields more accurate results, at expenses of a heavier computation.

If \code{f} yields negative values, these are silently truncated to zero.
}
\examples{
f <- function(x) rep(1, length(x))
plot(F_from_f(f = f, p = 4, Gauss = TRUE), ylab = "F(x)", xlim = c(-1, 1))
plot(F_from_f(f = f, p = 4, Gauss = FALSE), col = 2, add = TRUE,
     xlim = c(-1, 1))
curve(p_proj_unif(x = x, p = 4), col = 3, add = TRUE, n = 300)
plot(F_inv_from_f(f = f, p = 4, Gauss = TRUE), ylab = "F^{-1}(x)")
plot(F_inv_from_f(f = f, p = 4, Gauss = FALSE), col = 2, add = TRUE)
curve(q_proj_unif(u = x, p = 4), col = 3, add = TRUE, n = 300)
}
