% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{rhea}
\alias{rhea}
\title{Rhea craters from Hirata (2016)}
\format{
A data frame with 3596 rows and 4 variables:
\describe{
  \item{name}{name of the crater (if named).}
  \item{diameter}{diameter of the crater (in km).}
  \item{theta}{longitude angle \eqn{\theta \in [0, 2\pi)} of the
  crater center.}
  \item{phi}{latitude angle \eqn{\phi \in [-\pi/2, \pi/2]} of the
  crater center.}
}
}
\source{
\url{https://agupubs.onlinelibrary.wiley.com/action/downloadSupplement?doi=10.1002\%2F2015JE004940&file=jgre20485-sup-0002-TableS1.txt}
}
\usage{
rhea
}
\description{
Craters on Rhea from
\href{https://agupubs.onlinelibrary.wiley.com/doi/full/10.1002/2015JE004940}{
Hirata (2016)}.
}
\details{
The \eqn{(\theta, \phi)} angles are such their associated planetocentric
coordinates are:
\deqn{(\cos(\phi) \cos(\theta), \cos(\phi) \sin(\theta), \sin(\phi))',}{
(cos(\phi) cos(\theta), cos(\phi) sin(\theta), sin(\phi))',}
with \eqn{(0, 0, 1)'} denoting the north pole.

The script performing the data preprocessing is available at
\href{https://github.com/egarpor/sphunif/blob/master/data-raw/rhea.R}{
\code{rhea.R}}.
}
\examples{
# Load data
data("rhea")

# Add Cartesian coordinates
rhea$X <- cbind(cos(rhea$theta) * cos(rhea$phi),
                sin(rhea$theta) * cos(rhea$phi),
                sin(rhea$phi))

# Tests
unif_test(data = rhea$X[rhea$diam > 15 & rhea$diam < 20, ],
          type = c("PCvM", "PAD", "PRt"), p_value = "asymp")
}
\references{
Hirata, N. (2016) Differential impact cratering of Saturn's satellites by
heliocentric impactors. \emph{Journal of Geophysical Research: Planets},
121:111--117. \doi{10.1002/2015JE004940}
}
\keyword{datasets}
