% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impacts.R
\name{impacts.ols_sphet}
\alias{impacts.ols_sphet}
\title{Generate impacts for objects of class ols_sphet created in sphet}
\usage{
\method{impacts}{ols_sphet}(
  obj,
  ...,
  tr = NULL,
  R = NULL,
  listw = NULL,
  evalues = NULL,
  tol = 1e-06,
  empirical = FALSE,
  Q = NULL
)
}
\arguments{
\item{obj}{A spreg spatial regression object created by \code{spreg} with model ="lag"}

\item{...}{Arguments passed through to methods in the \pkg{coda} package}

\item{tr}{A vector of traces of powers of the spatial weights matrix created using \code{trW}, for approximate impact measures; if not given, \code{listw} must be given for exact measures (for small to moderate spatial weights matrices); the traces must be for the same spatial weights as were used in fitting the spatial regression}

\item{R}{If given, simulations are used to compute distributions for the impact measures, returned as \code{mcmc} objects}

\item{listw}{a listw object}

\item{evalues}{vector of eigenvalues of spatial weights matrix for impacts calculations}

\item{tol}{Argument passed to \code{mvrnorm}: tolerance (relative to largest variance) for numerical lack of positive-definiteness in the coefficient covariance matrix}

\item{empirical}{Argument passed to \code{mvrnorm} (default FALSE): if true, the coefficients and their covariance matrix specify the empirical not population mean and covariance matrix}

\item{Q}{default NULL, else an integer number of cumulative power series impacts to calculate if \code{tr} is given}
}
\value{
Estimate of the Average Total, Average Direct, and Average Indirect Effects
}
\description{
Generate impacts for objects of class ols_sphet created in sphet
}
\examples{
data(boston, package="spData")
Wb <- as(spdep::nb2listw(boston.soi), "CsparseMatrix") 
ev <- eigen(Wb)$values
trMatb <- spatialreg::trW(Wb, type="mult")

lm.D <- spreg(log(CMEDV) ~ CRIM + ZN + INDUS + CHAS + I(NOX^2) + I(RM^2) +  AGE + log(DIS), 
          data = boston.c, listw = Wb, model = "ols", Durbin =  TRUE)
summary(lm.D)
impacts(lm.D)
summary(impacts(lm.D))

lm.D2 <- spreg(log(CMEDV) ~ CRIM + ZN + INDUS + CHAS + I(NOX^2) + I(RM^2) +  AGE + log(DIS), 
               data = boston.c, listw = Wb, model = "ols", Durbin =  ~AGE)
summary(lm.D2)
impacts(lm.D2)
summary(impacts(lm.D2))

lm.D3 <- spreg(log(CMEDV) ~ CRIM + ZN +  CHAS + I(NOX^2) + I(RM^2) +  AGE, 
               data = boston.c, listw = Wb, model = "ols", Durbin =  ~AGE + INDUS )
summary(lm.D3)
impacts(lm.D3)
summary(impacts(lm.D3))

require("sf", quietly=TRUE)
columbus <- st_read(system.file("shapes/columbus.shp", package="spData")[1], quiet=TRUE)
col.gal.nb <- spdep::read.gal(system.file("weights/columbus.gal", package="spData")[1])
listw <- spdep::nb2listw(col.gal.nb)
knear <- spdep::knearneigh(cbind(columbus$X, columbus$Y), 5)
knb <- spdep::knn2nb(knear)
dist <- spdep::nbdists(knb, cbind(columbus$X, columbus$Y))
k5d <- spdep::nb2listw(knb, glist = dist, style = "B")
class(k5d) <- c("listw", "nb", "distance")
lm.D4 <- spreg(CRIME ~ INC + HOVAL, columbus, listw, Durbin=TRUE,
               model = "ols")
summary(lm.D4)
impacts(lm.D4)

lm.D5 <- spreg(CRIME ~ INC + HOVAL, columbus, listw, Durbin= ~ INC,
               model = "ols")
summary(lm.D5)
impacts(lm.D5)
summary(impacts(lm.D5))

lm.D6 <- spreg(CRIME ~ HOVAL, columbus, listw, Durbin= ~ INC,
               model = "ols")
summary(lm.D6)
summary(impacts(lm.D6))
\dontrun{
lm.D7 <- spreg(CRIME ~ INC + HOVAL, columbus, listw,
                 model = "ols", HAC = TRUE, distance = k5d, 
                                  type = "Triangular")
summary(lm.D7)
impacts(lm.D7)
summary(impacts(lm.D7))
}
lm.D8 <- spreg(CRIME ~ INC + HOVAL, data = columbus, listw = listw, Durbin=TRUE,
               model = "ols", distance = k5d, type = "Triangular")
summary(lm.D8)
impacts(lm.D8)
summary(impacts(lm.D8))


lmD.9 <- spreg(CRIME ~ INC + HOVAL, data = columbus, listw = listw, Durbin= ~ INC,
               model = "ols", distance = k5d, type = "Parzen")
               
impacts(lmD.9)

lmD.10 <- spreg(CRIME ~ HOVAL, columbus, listw, Durbin= ~ INC,
                model = "ols", distance = k5d, type = "Bisquare")
summary(lmD.10)
summary(impacts(lmD.10))
}
