% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delaunay.R
\name{DelaunayOnSphere}
\alias{DelaunayOnSphere}
\title{Spherical Delaunay triangulation}
\usage{
DelaunayOnSphere(vertices, radius = 1, center = c(0, 0, 0), iterations = 5L)
}
\arguments{
\item{vertices}{vertices, a numeric matrix with three columns}

\item{radius}{radius of the sphere, a positive number; the vertices will
be projected on this sphere}

\item{center}{center of the sphere, a numeric vector of length three; the
vertices will be projected on this sphere}

\item{iterations}{positive integer, the number of iterations used to
construct the meshes of the spherical faces}
}
\value{
A named list with four fields:
 \itemize{
   \item \code{vertices}, the matrix of vertices obtained by projecting the
   original vertices to the sphere;

   \item \code{faces}, an integer matrix providing by row the indices of
   the faces of the triangulation;

   \item \code{solidFaces}, an integer vector providing the indices of the
   solid faces; faces are either solid faces or ghost faces, see details

   \item \code{meshes}, a list of meshes of the solid faces used for
   plotting in \code{\link{plotDelaunayOnSphere}}.
 }
}
\description{
Computes a spherical Delaunay triangulation.
}
\details{
See \href{https://doc.cgal.org/latest/Triangulation_on_sphere_2/index.html}{2D Triangulations on the Sphere}.
}
\examples{
library(sphereTessellation)
library(rgl)

if(require(cooltools)) {
vertices <- fibonaccisphere(30L)
del <- DelaunayOnSphere(vertices)
\donttest{open3d(windowRect = 50 + c(0, 0, 512, 512), zoom = 0.8)
plotDelaunayOnSphere(del)}
}

if(require(uniformly)) {
# sample vertices on a hemisphere, so there will be some ghost faces
set.seed(421L)
vertices <- rphong_on_hemisphere(6L)
del <- DelaunayOnSphere(vertices)
# the ghost faces are not plotted
\donttest{open3d(windowRect = 50 + c(0, 0, 512, 512), zoom = 0.8)
plotDelaunayOnSphere(del)}
}
}
\seealso{
\code{\link{plotDelaunayOnSphere}}
}
