% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spew.R
\name{spew_sock}
\alias{spew_sock}
\title{Run SPEW in Parallel with a SOCK backend}
\usage{
spew_sock(num_places, pop_table, shapefile, pums_h, pums_p, schools, workplaces,
  marginals, output_type, output_dir, convert_count, sampling_method,
  locations_method, outfile_loc, export_objects, road_noise, timer, verbose)
}
\arguments{
\item{num_places}{The number of regions (place_ids) to be generated for a given location}

\item{pop_table}{dataframe where rows correspond to places where populations 
should be generated. Other requird columns are "n_house" and "puma_id"}

\item{shapefile}{sp class object used for assigning households to 
particular locations}

\item{pums_h}{dataframe with microdata corresponding to housegolds}

\item{pums_p}{dataframe with microdata corresponding to people}

\item{schools}{list with names "public" and "private" with a 
dataframe of schools corresponding to public or private, respectively}

\item{workplaces}{dataframe of workplaces with a workplace_id column, 
employees column, and stcotr column}

\item{marginals}{list of marginal population totals. Each element of the 
list contains the marginal totals of a separate variable}

\item{output_type}{Default is "console" if we want to resulting population 
as an R variable. Alternative is "write", which is used on Olympus for writing 
out .csv files of the population}

\item{output_dir}{directory to write output if output_type = "write", NULL otherwise}

\item{convert_count}{logical meant to indicate if we are going to convert 
population totals from people to household counts. Default: FALSE, assumes
the population is the total number of households}

\item{sampling_method}{character indicating the type of sampling 
method to use, defaults to "uniform". Can also be "ipf" with appropriate marginal data.}

\item{locations_method}{character indicating the type of location 
sampling to use, defaults to "uniform", can also be "roads".}

\item{outfile_loc}{Defaults to "", so we print out the parallel run information. 
Only set to "/dev/null" for internal testing putposes.}

\item{export_objects}{objects for exporting to parallel backends}

\item{road_noise}{Noise added to households during road-based sampling}

\item{timer}{logical indicating we want to time the run}

\item{verbose}{logical indicating we want to print output during the run.  Default is FALSE.#'}
}
\value{
region_list with output_type for all num_place locations
}
\description{
Internal function, only called by the main spew function
}
