% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sperrorest_resampling.R
\name{partition_factor}
\alias{partition_factor}
\title{Partition the data for a (non-spatial) leave-one-factor-out
cross-validation based on a given, fixed partitioning}
\usage{
partition_factor(
  data,
  coords = c("x", "y"),
  fac,
  return_factor = FALSE,
  repetition = 1
)
}
\arguments{
\item{data}{\code{data.frame} containing at least the columns specified by
\code{coords}}

\item{coords}{vector of length 2 defining the variables in \code{data} that
contain the x and y coordinates of sample locations.}

\item{fac}{either the name of a variable (column) in \code{data}, or a vector of
type factor and length \code{nrow(data)} that contains the partitions to be used
for defining training and test samples.}

\item{return_factor}{if \code{FALSE} (default), return a \link{represampling} object;
if \code{TRUE} (used internally by other {sperrorest} functions), return a
\code{list} containing factor vectors (see Value)}

\item{repetition}{numeric vector: cross-validation repetitions to be
generated. Note that this is not the number of repetitions, but the indices
of these repetitions. E.g., use \code{repetition = c(1:100)} to obtain (the
'first') 100 repetitions, and \code{repetition = c(101:200)} to obtain a
different set of 100 repetitions.}
}
\value{
A \link{represampling} object, see also \link{partition_cv} for details.
}
\description{
\code{partition_factor} creates a \link{represampling} object, i.e. a set
of sample indices defining cross-validation test and training sets.
}
\note{
In this partitioning approach, all \code{repetition}s are identical and
therefore pseudo-replications.
}
\examples{
data(ecuador)
# I don't recommend using this partitioning for cross-validation,
# this is only for demonstration purposes:
breaks <- quantile(ecuador$dem, seq(0, 1, length = 6))
ecuador$zclass <- cut(ecuador$dem, breaks, include.lowest = TRUE)
summary(ecuador$zclass)
parti <- partition_factor(ecuador, fac = "zclass")
# plot(parti,ecuador)
summary(parti)
}
\seealso{
\link{sperrorest}, \link{partition_cv}, \link{as.resampling.factor}
}
