% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_sintax_tax_table.R
\name{import_sintax_tax_table}
\alias{import_sintax_tax_table}
\title{Import SINTAX Taxonomy Table}
\usage{
import_sintax_tax_table(in_file, confidence)
}
\arguments{
\item{in_file}{A fix-rank tab-delimited text file output by SINTAX}

\item{confidence}{The confidence level for filtering the taxonomy (0.8 by default)}
}
\value{
A phyloseq tax_table object
}
\description{
Imports taxonomy files created with USEARCH and vsearch sintax commands
}
\details{
This function works with both vsearch and USEARCH sintax results.

A confidence value of 0.8 is recommended for full-length 16S rRNA gene sequences and a value of 0.5 is recommended for shorter amplicons.
}
\examples{
# With a vsearch sintax result
taxonomy_file <- system.file("extdata", "vsearch_sintax_table.tsv", package = "speedytax")
example_tax_table <- import_sintax_tax_table(in_file = taxonomy_file)
example_tax_table
# With a USEARCH sintax result
taxonomy_file <- system.file("extdata", "usearch_sintax_table.tsv", package = "speedytax")
example_tax_table <- import_sintax_tax_table(in_file = taxonomy_file)
example_tax_table
}
\references{
Rognes T, Flouri T, Nichols B, Quince C, Mahé F. (2016) VSEARCH: a versatile open source tool for metagenomics. PeerJ 4:e2584. doi: 10.7717/peerj.2584

Edgar RC (2016) SINTAX: a simple non-Bayesian taxonomy classifier for 16S and ITS sequences. bioRxiv. doi:10.1101/074161
}
