/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.support;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.gui.dock.station.support.PlaceholderStrategyListener;
import bibliothek.util.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootPlaceholderStrategy
implements PlaceholderStrategy {
    private DockStation station;
    private List<PlaceholderStrategyListener> listeners;
    private PlaceholderStrategy strategy;
    private Set<Path> placeholders = new HashSet<Path>();
    private PlaceholderStrategyListener listener = new PlaceholderStrategyListener(){

        @Override
        public void placeholderInvalidated(Set<Path> placeholder) {
            RootPlaceholderStrategy.this.placeholders.removeAll(placeholder);
        }
    };

    public RootPlaceholderStrategy(DockStation station) {
        this.station = station;
    }

    public void setStrategy(PlaceholderStrategy strategy) {
        if (this.strategy != strategy) {
            if (this.strategy != null) {
                this.strategy.removeListener(this.listener);
                this.strategy.uninstall(this.station);
            }
            this.strategy = strategy;
            if (this.strategy == null) {
                if (!this.placeholders.isEmpty()) {
                    this.fireRemoved(Collections.unmodifiableSet(this.placeholders));
                    this.placeholders.clear();
                }
            } else {
                this.strategy.install(this.station);
                this.strategy.addListener(this.listener);
                HashSet<Path> removed = new HashSet<Path>();
                Iterator<Path> iter = this.placeholders.iterator();
                while (iter.hasNext()) {
                    Path next = iter.next();
                    if (this.strategy.isValidPlaceholder(next)) continue;
                    iter.remove();
                    removed.add(next);
                }
                if (!removed.isEmpty()) {
                    this.fireRemoved(removed);
                }
            }
        }
    }

    private void fireRemoved(Set<Path> placeholders) {
        for (PlaceholderStrategyListener listener : this.listeners.toArray(new PlaceholderStrategyListener[this.listeners.size()])) {
            listener.placeholderInvalidated(placeholders);
        }
    }

    public PlaceholderStrategy getStrategy() {
        return this.strategy;
    }

    @Override
    public void addListener(PlaceholderStrategyListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<PlaceholderStrategyListener>();
        }
        this.listeners.add(listener);
        if (this.strategy != null) {
            this.strategy.addListener(listener);
        }
    }

    @Override
    public void removeListener(PlaceholderStrategyListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
        if (this.strategy != null) {
            this.strategy.removeListener(listener);
        }
    }

    @Override
    public Path getPlaceholderFor(Dockable dockable) {
        if (this.strategy == null) {
            return null;
        }
        Path result = this.strategy.getPlaceholderFor(dockable);
        if (result != null) {
            this.placeholders.add(result);
        }
        return result;
    }

    @Override
    public void install(DockStation station) {
        throw new IllegalStateException("this strategy must not be installed");
    }

    @Override
    public boolean isValidPlaceholder(Path placeholder) {
        if (this.strategy == null) {
            return false;
        }
        boolean result = this.strategy.isValidPlaceholder(placeholder);
        if (result) {
            this.placeholders.add(placeholder);
        }
        return result;
    }

    @Override
    public void uninstall(DockStation station) {
        throw new IllegalStateException("this strategy must not be uninstalled");
    }
}

