/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.support.lookandfeel;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LookAndFeelUtilities {
    public static void updateUI(Collection<Component> collection) {
        HashSet<Component> hashSet = new HashSet<Component>();
        for (Component component : collection) {
            Window window = SwingUtilities.getWindowAncestor(component = LookAndFeelUtilities.getAncestor(component));
            if (window != null) {
                LookAndFeelUtilities.change(window, hashSet);
                continue;
            }
            LookAndFeelUtilities.change(component, hashSet);
        }
    }

    private static Component getAncestor(Component component) {
        Container container = component.getParent();
        if (container == null) {
            return component;
        }
        return LookAndFeelUtilities.getAncestor(container);
    }

    private static void change(Component component, Set<Component> set) {
        if (set.add(component)) {
            SwingUtilities.updateComponentTreeUI(component);
            if (component instanceof Window) {
                Window window = (Window)component;
                for (Window window2 : window.getOwnedWindows()) {
                    LookAndFeelUtilities.change(window2, set);
                }
            }
        }
    }
}

