/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.mode.station;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.ScreenDockStation;
import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.mode.CExternalizedModeArea;
import bibliothek.gui.dock.common.mode.CLocationMode;
import bibliothek.gui.dock.common.mode.CLocationModeManager;
import bibliothek.gui.dock.common.mode.CMaximizedMode;
import bibliothek.gui.dock.common.mode.CMaximizedModeArea;
import bibliothek.gui.dock.common.mode.CModeArea;
import bibliothek.gui.dock.facile.mode.ExternalizedMode;
import bibliothek.gui.dock.facile.mode.Location;
import bibliothek.gui.dock.facile.mode.LocationMode;
import bibliothek.gui.dock.facile.mode.LocationModeEvent;
import bibliothek.gui.dock.facile.mode.MaximizedMode;
import bibliothek.gui.dock.facile.mode.MaximizedModeArea;
import bibliothek.gui.dock.facile.mode.ModeAreaListener;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.station.screen.ScreenDockProperty;
import bibliothek.gui.dock.station.screen.ScreenDockStationListener;
import bibliothek.gui.dock.station.screen.ScreenDockWindow;
import bibliothek.gui.dock.support.mode.AffectedSet;
import bibliothek.gui.dock.util.DockUtilities;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CScreenDockStationHandle {
    private CLocation location;
    private CStation<ScreenDockStation> station;
    private External external = new External();
    private Maximal maximal = new Maximal();
    private LocationMode externalMode;
    private CMaximizedMode maximizedMode;
    private CLocationModeManager manager;

    public CScreenDockStationHandle(CStation<ScreenDockStation> cStation, CLocationModeManager cLocationModeManager) {
        this.station = cStation;
        this.manager = cLocationModeManager;
        cStation.getStation().addScreenDockStationListener(new ScreenDockStationListener(){

            public void windowRegistering(ScreenDockStation screenDockStation, Dockable dockable, ScreenDockWindow screenDockWindow) {
            }

            public void windowDeregistering(ScreenDockStation screenDockStation, Dockable dockable, ScreenDockWindow screenDockWindow) {
            }

            public void fullscreenChanged(ScreenDockStation screenDockStation, Dockable dockable) {
                ModeAreaListener[] modeAreaListenerArray;
                CModeArea cModeArea;
                if (screenDockStation.isFullscreen(dockable)) {
                    cModeArea = CScreenDockStationHandle.this.maximal;
                    modeAreaListenerArray = CScreenDockStationHandle.this.maximal.listeners();
                } else {
                    cModeArea = CScreenDockStationHandle.this.external;
                    modeAreaListenerArray = CScreenDockStationHandle.this.external.listeners();
                }
                HashSet<Dockable> hashSet = new HashSet<Dockable>();
                hashSet.add(dockable);
                for (ModeAreaListener modeAreaListener : modeAreaListenerArray) {
                    modeAreaListener.internalLocationChange(cModeArea, hashSet);
                }
            }
        });
    }

    public CExternalizedModeArea getExternalizedModeArea() {
        return this.external;
    }

    public CMaximizedModeArea getMaximizedModeArea() {
        return this.maximal;
    }

    public CLocation getCLocation(Dockable dockable) {
        DockableProperty dockableProperty = DockUtilities.getPropertyChain(this.station.getStation(), dockable);
        return this.location.expandProperty(dockableProperty);
    }

    public CLocation getCLocation(Dockable dockable, Location location) {
        DockableProperty dockableProperty = location.getLocation();
        if (dockableProperty == null) {
            return this.location;
        }
        return this.location.expandProperty(dockableProperty);
    }

    protected class Maximal
    implements CMaximizedModeArea {
        private List<ModeAreaListener> listeners = new ArrayList<ModeAreaListener>();

        protected Maximal() {
        }

        public Dockable[] getMaximized() {
            return ((ScreenDockStation)CScreenDockStationHandle.this.station.getStation()).getFullscreenChildren();
        }

        public boolean isRepresenting(DockStation dockStation) {
            return CScreenDockStationHandle.this.station.getStation() == dockStation;
        }

        public boolean autoDefaultArea() {
            return false;
        }

        public Runnable onApply(LocationModeEvent locationModeEvent) {
            if (locationModeEvent.isDone()) {
                return null;
            }
            Location location = locationModeEvent.getLocation();
            Dockable dockable = locationModeEvent.getDockable();
            if (locationModeEvent.getMode().getUniqueIdentifier().equals(ExternalizedMode.IDENTIFIER)) {
                MaximizedModeArea maximizedModeArea;
                CLocationMode cLocationMode = (CLocationMode)CScreenDockStationHandle.this.manager.getCurrentMode(dockable);
                CLocationMode cLocationMode2 = (CLocationMode)CScreenDockStationHandle.this.manager.getPreviousMode(dockable);
                if (cLocationMode != null && cLocationMode2 != null && ExternalizedMode.IDENTIFIER.equals(cLocationMode2.getUniqueIdentifier()) && MaximizedMode.IDENTIFIER.equals(cLocationMode.getUniqueIdentifier()) && (maximizedModeArea = (MaximizedModeArea)CScreenDockStationHandle.this.maximizedMode.get(location.getRoot())) == this) {
                    dockable = CScreenDockStationHandle.this.maximizedMode.getMaximizingElement(dockable);
                    maximizedModeArea.setMaximized(dockable, false, null, locationModeEvent.getAffected());
                    locationModeEvent.done();
                    return null;
                }
            }
            return null;
        }

        public Runnable onApply(LocationModeEvent locationModeEvent, Dockable dockable) {
            return null;
        }

        public void prepareApply(Dockable dockable, Location location, AffectedSet affectedSet) {
        }

        public LocationMode getUnmaximizedMode() {
            return CScreenDockStationHandle.this.externalMode;
        }

        public void setMaximized(Dockable dockable, boolean bl, Location location, AffectedSet affectedSet) {
            ScreenDockStation screenDockStation = this.getStation();
            DockStation dockStation = dockable.getDockParent();
            if (bl) {
                if (dockStation == screenDockStation) {
                    screenDockStation.setFullscreen(dockable, true);
                } else {
                    Dockable dockable2 = DockUtilities.getDirectChild(screenDockStation, dockable);
                    if (dockable2 == null) {
                        throw new IllegalArgumentException("dockable not a child of this station");
                    }
                    if (!dockStation.canDrag(dockable)) {
                        throw new IllegalArgumentException("cannot drag dockable from its parent");
                    }
                    dockStation.drag(dockable);
                    if (!screenDockStation.drop(dockable, dockable2)) {
                        throw new IllegalStateException("cannot drop dockable on this station");
                    }
                    screenDockStation.setFullscreen(dockable, true);
                }
            } else if (dockStation == screenDockStation) {
                screenDockStation.setFullscreen(dockable, false);
            } else {
                Dockable dockable3 = DockUtilities.getDirectChild(screenDockStation, dockable);
                ScreenDockProperty screenDockProperty = screenDockStation.getLocation(dockable3, dockable);
                if (!dockStation.canDrag(dockable)) {
                    throw new IllegalArgumentException("cannot drag dockable from its current parent");
                }
                screenDockProperty.setFullscreen(false);
                if (!screenDockStation.drop(dockable, screenDockProperty, true)) {
                    throw new IllegalStateException("could not drop dockable on this station");
                }
            }
        }

        public void addModeAreaListener(ModeAreaListener modeAreaListener) {
            this.listeners.add(modeAreaListener);
        }

        public void removeModeAreaListener(ModeAreaListener modeAreaListener) {
            this.listeners.remove(modeAreaListener);
        }

        public ModeAreaListener[] listeners() {
            return this.listeners.toArray(new ModeAreaListener[this.listeners.size()]);
        }

        public ScreenDockStation getStation() {
            return (ScreenDockStation)CScreenDockStationHandle.this.station.getStation();
        }

        public String getUniqueId() {
            return CScreenDockStationHandle.this.station.getUniqueId();
        }

        public boolean isChild(Dockable dockable) {
            ScreenDockStation screenDockStation = this.getStation();
            return dockable.getDockParent() == screenDockStation && screenDockStation.isFullscreen(dockable);
        }

        public boolean respectWorkingAreas() {
            return false;
        }

        public void setController(DockController dockController) {
        }

        public void setMode(LocationMode locationMode) {
            CScreenDockStationHandle.this.maximizedMode = (CMaximizedMode)locationMode;
        }

        public CLocation getCLocation(Dockable dockable) {
            return CScreenDockStationHandle.this.getCLocation(dockable);
        }

        public CLocation getCLocation(Dockable dockable, Location location) {
            return CScreenDockStationHandle.this.getCLocation(dockable, location);
        }
    }

    protected class External
    implements CExternalizedModeArea {
        private List<ModeAreaListener> listeners = new ArrayList<ModeAreaListener>();

        protected External() {
        }

        public DockableProperty getLocation(Dockable dockable) {
            return DockUtilities.getPropertyChain(this.getStation(), dockable);
        }

        public boolean autoDefaultArea() {
            return true;
        }

        public void setLocation(Dockable dockable, DockableProperty dockableProperty, AffectedSet affectedSet) {
            affectedSet.add(dockable);
            if (this.isChild(dockable)) {
                if (dockableProperty != null) {
                    ((ScreenDockStation)CScreenDockStationHandle.this.station.getStation()).move(dockable, dockableProperty);
                }
            } else {
                if (dockableProperty != null && !((ScreenDockStation)CScreenDockStationHandle.this.station.getStation()).drop(dockable, dockableProperty)) {
                    dockableProperty = null;
                }
                if (dockableProperty == null) {
                    ((ScreenDockStation)CScreenDockStationHandle.this.station.getStation()).drop(dockable);
                }
            }
        }

        public void addModeAreaListener(ModeAreaListener modeAreaListener) {
            this.listeners.add(modeAreaListener);
        }

        public void removeModeAreaListener(ModeAreaListener modeAreaListener) {
            this.listeners.remove(modeAreaListener);
        }

        public ModeAreaListener[] listeners() {
            return this.listeners.toArray(new ModeAreaListener[this.listeners.size()]);
        }

        public DockStation getStation() {
            return CScreenDockStationHandle.this.station.getStation();
        }

        public String getUniqueId() {
            return CScreenDockStationHandle.this.station.getUniqueId();
        }

        public boolean isChild(Dockable dockable) {
            return dockable.getDockParent() == CScreenDockStationHandle.this.station.getStation() && !((ScreenDockStation)CScreenDockStationHandle.this.station.getStation()).isFullscreen(dockable);
        }

        public boolean respectWorkingAreas() {
            return false;
        }

        public void setController(DockController dockController) {
        }

        public void setMode(LocationMode locationMode) {
            CScreenDockStationHandle.this.externalMode = locationMode;
        }

        public CLocation getCLocation(Dockable dockable) {
            return CScreenDockStationHandle.this.getCLocation(dockable);
        }

        public CLocation getCLocation(Dockable dockable, Location location) {
            return CScreenDockStationHandle.this.getCLocation(dockable, location);
        }
    }
}

