/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.util.xml;

import bibliothek.util.xml.XAttribute;
import bibliothek.util.xml.XElement;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedList;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XIO {
    public static void write(XElement xElement, Appendable appendable) throws IOException {
        appendable.append("<?xml version='1.0'?>\n");
        XIO.write(xElement, 0, appendable);
    }

    public static void writeUTF(XElement xElement, OutputStream outputStream) throws IOException {
        XIO.write(xElement, outputStream, "UTF-8");
    }

    public static void write(XElement xElement, OutputStream outputStream, String string) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, string){

            public void close() throws IOException {
            }
        };
        XIO.write(xElement, outputStreamWriter);
        outputStreamWriter.flush();
    }

    public static XElement readUTF(InputStream inputStream) throws IOException {
        return XIO.read(inputStream, "UTF-8");
    }

    public static XElement read(InputStream inputStream, String string) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, string){

            public void close() throws IOException {
            }
        };
        return XIO.read(new InputSource(inputStreamReader));
    }

    private static void write(XElement xElement, int n, Appendable appendable) throws IOException {
        for (int i = 0; i < n; ++i) {
            appendable.append("\t");
        }
        appendable.append("<");
        appendable.append(xElement.getName());
        for (XAttribute xAttribute : xElement.attributes()) {
            appendable.append(" ");
            appendable.append(xAttribute.getName());
            appendable.append("=\"");
            XIO.encode(xAttribute.getString(), appendable);
            appendable.append("\"");
        }
        String string = xElement.getValue();
        XElement[] xElementArray = xElement.children();
        if (string.length() == 0 && xElementArray.length == 0) {
            appendable.append("/>");
        } else {
            appendable.append(">");
            if (string.length() > 0) {
                if (xElementArray.length > 0) {
                    appendable.append("\n\t");
                    for (int i = 0; i < n; ++i) {
                        appendable.append("\t");
                    }
                }
                XIO.encode(string, appendable);
            }
            if (xElementArray.length > 0) {
                appendable.append("\n");
                for (XElement xElement2 : xElementArray) {
                    XIO.write(xElement2, n + 1, appendable);
                    appendable.append("\n");
                }
                for (int i = 0; i < n; ++i) {
                    appendable.append("\t");
                }
            }
            appendable.append("</");
            appendable.append(xElement.getName());
            appendable.append(">");
        }
    }

    private static void encode(String string, Appendable appendable) throws IOException {
        int n = string.length();
        block7: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    appendable.append("&lt;");
                    continue block7;
                }
                case '>': {
                    appendable.append("&gt;");
                    continue block7;
                }
                case '\'': {
                    appendable.append("&apos;");
                    continue block7;
                }
                case '\"': {
                    appendable.append("&quot;");
                    continue block7;
                }
                case '&': {
                    appendable.append("&amp;");
                    continue block7;
                }
                default: {
                    appendable.append(c);
                }
            }
        }
    }

    public static XElement read(CharSequence charSequence) throws IOException {
        InputSource inputSource = new InputSource();
        inputSource.setCharacterStream(new StringReader(((Object)charSequence).toString()));
        return XIO.read(inputSource);
    }

    public static XElement read(InputSource inputSource) throws IOException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            Handler handler = new Handler();
            sAXParser.parse(inputSource, (DefaultHandler)handler);
            return handler.getElement();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException(parserConfigurationException.getMessage());
        }
        catch (SAXException sAXException) {
            throw new IOException(sAXException.getMessage());
        }
    }

    public static XElement read(Reader reader) throws IOException {
        return XIO.read(new InputSource(reader));
    }

    private static class Handler
    extends DefaultHandler {
        private XElement element;
        private LinkedList<XElement> stack = new LinkedList();

        private Handler() {
        }

        public XElement getElement() {
            return this.element;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            XElement xElement = new XElement(string3);
            if (this.element == null) {
                this.element = xElement;
            } else {
                this.stack.getFirst().addElement(xElement);
            }
            this.stack.addFirst(xElement);
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                XAttribute xAttribute = new XAttribute(attributes.getQName(i));
                xAttribute.setString(attributes.getValue(i));
                xElement.addAttribute(xAttribute);
            }
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (n2 > 0) {
                String string = new String(cArray, n, n2);
                String string2 = this.stack.getFirst().getValue();
                if (string2 != null && string2.length() > 0) {
                    string = string2 + string;
                }
                this.stack.getFirst().setValue(string);
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            XElement xElement = this.stack.removeFirst();
            xElement.setValue(xElement.getString().trim());
        }
    }
}

