/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.util;

import bibliothek.gui.dock.util.AbstractWindowProvider;
import bibliothek.gui.dock.util.WindowProviderListener;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.SwingUtilities;

public class ComponentWindowProvider
extends AbstractWindowProvider {
    private Component component;
    private Window window;
    private HierarchyListener listener = new HierarchyListener(){

        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            Window window = ComponentWindowProvider.this.window;
            ComponentWindowProvider.this.window = ComponentWindowProvider.this.getWindowAncestor(ComponentWindowProvider.this.component);
            if (window != ComponentWindowProvider.this.window) {
                ComponentWindowProvider.this.fireWindowChanged(ComponentWindowProvider.this.window);
            }
        }
    };

    public ComponentWindowProvider(Component component) {
        this.component = component;
    }

    public void addWindowProviderListener(WindowProviderListener windowProviderListener) {
        int n = this.listeners.size();
        super.addWindowProviderListener(windowProviderListener);
        if (n == 0 && this.listeners.size() > 0 && this.component != null) {
            this.component.addHierarchyListener(this.listener);
            this.window = this.getWindowAncestor(this.component);
        }
    }

    public void removeWindowProviderListener(WindowProviderListener windowProviderListener) {
        int n = this.listeners.size();
        super.removeWindowProviderListener(windowProviderListener);
        if (n > 0 && this.listeners.size() == 0 && this.component != null) {
            this.component.removeHierarchyListener(this.listener);
        }
    }

    public Component getComponent() {
        return this.component;
    }

    public void setComponent(Component component) {
        if (this.listeners.size() == 0) {
            this.component = component;
        } else {
            if (this.component != null) {
                this.component.removeHierarchyListener(this.listener);
            }
            this.component = component;
            if (this.component != null) {
                this.component.addHierarchyListener(this.listener);
            }
            Window window = this.window;
            Window window2 = this.window = component == null ? null : this.getWindowAncestor(component);
            if (window != this.window) {
                this.fireWindowChanged(this.window);
            }
        }
    }

    public Window searchWindow() {
        if (this.component == null) {
            return null;
        }
        if (this.listeners.size() == 0) {
            return this.getWindowAncestor(this.component);
        }
        return this.window;
    }

    private Window getWindowAncestor(Component component) {
        if (component instanceof Window) {
            return (Window)component;
        }
        return SwingUtilities.getWindowAncestor(component);
    }
}

