/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack.tab.layouting;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.stack.tab.AxisConversion;
import bibliothek.gui.dock.station.stack.tab.DefaultAxisConversion;
import bibliothek.gui.dock.station.stack.tab.Tab;
import bibliothek.gui.dock.station.stack.tab.TabPane;
import bibliothek.gui.dock.station.stack.tab.TabPaneComponent;
import bibliothek.gui.dock.station.stack.tab.layouting.Size;
import bibliothek.gui.dock.station.stack.tab.layouting.TabsLayoutBlock;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;

public class LineTabsLayoutBlock
extends TabsLayoutBlock {
    private boolean sameSize = true;

    public boolean isSameSize() {
        return this.sameSize;
    }

    public void setSameSize(boolean bl) {
        this.sameSize = bl;
    }

    protected void checkSelection() {
        if (this.getSelectedTab() != null) {
            return;
        }
        TabPane tabPane = this.getPane();
        if (tabPane == null) {
            return;
        }
        Dockable dockable = tabPane.getSelectedDockable();
        if (dockable == null) {
            return;
        }
        this.insertTab(tabPane.putOnTab(dockable));
    }

    public LineSize[] getSizes() {
        Tab[] tabArray = this.getTabsOrderedByImportance();
        SizeCollector sizeCollector = new SizeCollector(this.getPane().getDockables());
        LineSize[] lineSizeArray = new LineSize[tabArray.length + 1];
        for (int i = 0; i < tabArray.length; ++i) {
            sizeCollector.insert(tabArray[i]);
            Dimension dimension = sizeCollector.getMinimumSize();
            Tab[] tabArray2 = new Tab[i + 1];
            System.arraycopy(tabArray, 0, tabArray2, 0, i + 1);
            lineSizeArray[i] = new LineSize(Size.Type.MINIMUM, dimension, tabArray2, i + 1 == tabArray.length);
        }
        lineSizeArray[tabArray.length] = new LineSize(Size.Type.PREFERRED, sizeCollector.getPreferredSize(), tabArray, true);
        return lineSizeArray;
    }

    public void doLayout() {
        Tab[] tabArray;
        int n;
        Tab[] tabArray2 = this.getTabs();
        Rectangle rectangle = this.getBounds();
        DefaultAxisConversion defaultAxisConversion = new DefaultAxisConversion(rectangle, this.getOrientation());
        rectangle = defaultAxisConversion.viewToModel(rectangle);
        Dimension[] dimensionArray = new Dimension[tabArray2.length];
        Dimension[] dimensionArray2 = new Dimension[tabArray2.length];
        int n2 = 0;
        int n3 = 0;
        int[] nArray = this.getOverlapToPrevious(tabArray2);
        int[] nArray2 = this.getOverlapToNext(tabArray2);
        for (int i = 0; i < tabArray2.length; ++i) {
            dimensionArray[i] = defaultAxisConversion.viewToModel(tabArray2[i].getPreferredSize());
            dimensionArray2[i] = defaultAxisConversion.viewToModel(tabArray2[i].getMinimumSize());
            n2 += dimensionArray[i].width;
            n3 += dimensionArray2[i].width;
            if (i <= 0) continue;
            n = Math.max(nArray[i], nArray2[i - 1]);
            n2 -= n;
            n3 -= n;
        }
        ZOrder zOrder = new ZOrder(tabArray2);
        if (n2 <= rectangle.width) {
            this.doLayoutPreferred(defaultAxisConversion, rectangle.width, rectangle.height, dimensionArray, tabArray2, zOrder, nArray, nArray2);
        } else if (n3 <= rectangle.width) {
            this.doLayoutMinimum(defaultAxisConversion, rectangle.width, rectangle.height, dimensionArray2, dimensionArray, tabArray2, zOrder, nArray, nArray2);
        } else {
            this.doLayoutShrinked(defaultAxisConversion, rectangle.width, rectangle.height, dimensionArray2, tabArray2, zOrder, nArray, nArray2);
        }
        n = 0;
        for (Tab tab : tabArray = zOrder.getOrderedByZ()) {
            if (tab == null) continue;
            tab.setZOrder(n++);
        }
    }

    private int[] getOverlapToPrevious(Tab[] tabArray) {
        boolean bl = this.getOrientation().isHorizontal();
        int[] nArray = new int[tabArray.length];
        for (int i = 1; i < tabArray.length; ++i) {
            Insets insets = tabArray[i].getOverlap(tabArray[i - 1]);
            nArray[i] = bl ? insets.left : insets.top;
        }
        return nArray;
    }

    private int[] getOverlapToNext(Tab[] tabArray) {
        boolean bl = this.getOrientation().isHorizontal();
        int[] nArray = new int[tabArray.length];
        for (int i = tabArray.length - 2; i >= 0; --i) {
            Insets insets = tabArray[i].getOverlap(tabArray[i + 1]);
            nArray[i] = bl ? insets.right : insets.bottom;
        }
        return nArray;
    }

    private void doLayoutPreferred(AxisConversion axisConversion, int n, int n2, Dimension[] dimensionArray, Tab[] tabArray, ZOrder zOrder, int[] nArray, int[] nArray2) {
        int n3 = 0;
        for (int i = 0; i < tabArray.length; ++i) {
            Dimension dimension = dimensionArray[i];
            tabArray[i].setBounds(axisConversion.modelToView(new Rectangle(n3, 0, dimension.width, this.sameSize ? n2 : Math.min(n2, dimension.height))));
            n3 += dimension.width;
            if (i + 1 >= tabArray.length) continue;
            if (nArray2[i] > nArray[i + 1]) {
                n3 -= nArray2[i];
                zOrder.putOrder(tabArray[i + 1], tabArray[i]);
                continue;
            }
            n3 -= nArray[i + 1];
            zOrder.putOrder(tabArray[i], tabArray[i + 1]);
        }
    }

    private void doLayoutMinimum(AxisConversion axisConversion, int n, int n2, Dimension[] dimensionArray, Dimension[] dimensionArray2, Tab[] tabArray, ZOrder zOrder, int[] nArray, int[] nArray2) {
        int n3;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        for (Dimension dimension : dimensionArray) {
            n5 += dimension.width;
        }
        Dimension[] dimensionArray3 = dimensionArray2;
        int n7 = dimensionArray3.length;
        for (n3 = 0; n3 < n7; ++n3) {
            Dimension dimension;
            dimension = dimensionArray3[n3];
            n6 += dimension.width;
        }
        double d = (double)(n - n5) / (double)(n6 - n5);
        for (n3 = 0; n3 < tabArray.length - 1; ++n3) {
            int n8 = (int)((double)dimensionArray[n3].width + d * (double)(dimensionArray2[n3].width - dimensionArray[n3].width));
            tabArray[n3].setBounds(axisConversion.modelToView(new Rectangle(n4, 0, n8, this.sameSize ? n2 : Math.min(n2, dimensionArray2[n3].height))));
            n4 += n8;
            if (nArray2[n3] > nArray[n3 + 1]) {
                n4 -= nArray2[n3];
                zOrder.putOrder(tabArray[n3 + 1], tabArray[n3]);
                continue;
            }
            n4 -= nArray[n3 + 1];
            zOrder.putOrder(tabArray[n3], tabArray[n3 + 1]);
        }
        if (tabArray.length > 0) {
            n3 = tabArray.length - 1;
            int n9 = Math.min(n - n4, dimensionArray2[n3].width);
            tabArray[n3].setBounds(axisConversion.modelToView(new Rectangle(n4, 0, n9, this.sameSize ? n2 : Math.min(n2, dimensionArray2[n3].height))));
        }
    }

    private void doLayoutShrinked(AxisConversion axisConversion, int n, int n2, Dimension[] dimensionArray, Tab[] tabArray, ZOrder zOrder, int[] nArray, int[] nArray2) {
        int n3;
        int n4 = 0;
        int n5 = 0;
        Dimension[] dimensionArray2 = dimensionArray;
        int n6 = dimensionArray2.length;
        for (n3 = 0; n3 < n6; ++n3) {
            Dimension dimension = dimensionArray2[n3];
            n5 += dimension.width;
        }
        double d = (double)n5 / (double)n;
        for (n3 = 0; n3 < tabArray.length - 1; ++n3) {
            int n7 = (int)(d * (double)dimensionArray[n3].width);
            tabArray[n3].setBounds(axisConversion.modelToView(new Rectangle(n4, 0, n7, this.sameSize ? n2 : Math.min(n2, dimensionArray[n3].height))));
            n4 += n7;
            if (nArray2[n3] > nArray[n3 + 1]) {
                n4 -= nArray2[n3];
                zOrder.putOrder(tabArray[n3 + 1], tabArray[n3]);
                continue;
            }
            n4 -= nArray[n3 + 1];
            zOrder.putOrder(tabArray[n3], tabArray[n3 + 1]);
        }
        n3 = tabArray.length - 1;
        if (n3 >= 0) {
            tabArray[n3].setBounds(axisConversion.modelToView(new Rectangle(n4, 0, n - n4, this.sameSize ? n2 : Math.min(n2, dimensionArray[n3].height))));
        }
    }

    protected class SizeCollector {
        private Dockable[] dockables;
        private Tab[] tabs;
        private Dimension[] minimum;
        private Dimension[] preferred;
        private int[] overlapPrevious;
        private int[] overlapNext;

        public SizeCollector(Dockable[] dockableArray) {
            this.dockables = dockableArray;
            int n = dockableArray.length;
            this.tabs = new Tab[n];
            this.minimum = new Dimension[n];
            this.preferred = new Dimension[n];
            this.overlapPrevious = new int[n];
            this.overlapNext = new int[n];
        }

        public void insert(Tab tab) {
            Dockable dockable = tab.getDockable();
            for (int i = 0; i < this.dockables.length; ++i) {
                if (this.dockables[i] != dockable) continue;
                this.insert(tab, i);
                return;
            }
        }

        private Tab[] getVisibleTabs() {
            int n = 0;
            for (Tab tab : this.tabs) {
                if (tab == null) continue;
                ++n;
            }
            Tab[] tabArray = new Tab[n];
            int n2 = 0;
            for (Tab tab : this.tabs) {
                if (tab == null) continue;
                tabArray[n2++] = tab;
            }
            return tabArray;
        }

        private void insert(Tab tab, int n) {
            int n2;
            this.tabs[n] = tab;
            Tab[] tabArray = this.getVisibleTabs();
            this.minimum[n] = tab.getMinimumSize(tabArray);
            this.preferred[n] = tab.getPreferredSize(tabArray);
            boolean bl = LineTabsLayoutBlock.this.getOrientation().isHorizontal();
            for (n2 = n - 1; n2 >= 0; --n2) {
                if (this.tabs[n2] == null) continue;
                if (bl) {
                    this.overlapNext[n2] = this.tabs[n2].getOverlap((TabPaneComponent)tab).right;
                    this.overlapPrevious[n] = tab.getOverlap((TabPaneComponent)this.tabs[n2]).left;
                    break;
                }
                this.overlapNext[n2] = this.tabs[n2].getOverlap((TabPaneComponent)tab).bottom;
                this.overlapPrevious[n] = tab.getOverlap((TabPaneComponent)this.tabs[n2]).top;
                break;
            }
            for (n2 = n + 1; n2 < this.tabs.length; ++n2) {
                if (this.tabs[n2] == null) continue;
                if (bl) {
                    this.overlapNext[n] = tab.getOverlap((TabPaneComponent)this.tabs[n2]).right;
                    this.overlapPrevious[n2] = this.tabs[n2].getOverlap((TabPaneComponent)tab).left;
                    break;
                }
                this.overlapNext[n] = tab.getOverlap((TabPaneComponent)this.tabs[n2]).bottom;
                this.overlapPrevious[n2] = this.tabs[n2].getOverlap((TabPaneComponent)tab).top;
                break;
            }
        }

        public Dimension getMinimumSize() {
            return this.getSize(this.minimum);
        }

        public Dimension getPreferredSize() {
            return this.getSize(this.preferred);
        }

        private Dimension getSize(Dimension[] dimensionArray) {
            int n = 0;
            int n2 = 0;
            int n3 = -1;
            if (LineTabsLayoutBlock.this.getOrientation().isHorizontal()) {
                for (int i = 0; i < this.tabs.length; ++i) {
                    if (this.tabs[i] == null) continue;
                    Dimension dimension = dimensionArray[i];
                    n2 = Math.max(n2, dimension.height);
                    n += dimension.width;
                    if (n3 != -1) {
                        n -= Math.max(this.overlapNext[n3], this.overlapPrevious[i]);
                    }
                    n3 = i;
                }
            } else {
                for (int i = 0; i < this.tabs.length; ++i) {
                    if (this.tabs[i] == null) continue;
                    Dimension dimension = dimensionArray[i];
                    n = Math.max(n, dimension.width);
                    n2 += dimension.height;
                    if (n3 != -1) {
                        n2 -= Math.max(this.overlapNext[n3], this.overlapPrevious[i]);
                    }
                    n3 = i;
                }
            }
            return new Dimension(n, n2);
        }
    }

    protected class ZOrder {
        private Tab[] tabs;
        private List<Integer>[] onTop;
        private List<Integer>[] onBottom;

        public ZOrder(Tab[] tabArray) {
            this.tabs = tabArray;
            this.onTop = new List[tabArray.length];
            this.onBottom = new List[tabArray.length];
            for (int i = 0; i < tabArray.length; ++i) {
                this.onTop[i] = new ArrayList<Integer>(5);
                this.onBottom[i] = new ArrayList<Integer>(5);
            }
        }

        public void putOrder(Tab tab, Tab tab2) {
            for (int i = 0; i < this.tabs.length; ++i) {
                if (this.tabs[i] != tab) continue;
                for (int j = 0; j < this.tabs.length; ++j) {
                    if (this.tabs[j] != tab2) continue;
                    this.onTop[j].add(i);
                    this.onBottom[i].add(j);
                    return;
                }
            }
        }

        public int[] getZOrders() {
            int[] nArray = new int[this.tabs.length];
            boolean[] blArray = new boolean[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                for (int j = 0; j < nArray.length; ++j) {
                    if (blArray[j] || !this.onTop[j].isEmpty()) continue;
                    nArray[j] = nArray.length - i;
                    blArray[j] = true;
                    Integer n = i;
                    for (int n2 : this.onBottom[j]) {
                        this.onTop[n2].remove(n);
                    }
                }
            }
            return nArray;
        }

        public Tab[] getOrderedByZ() {
            Tab[] tabArray = new Tab[this.tabs.length];
            boolean[] blArray = new boolean[tabArray.length];
            block0: for (int i = 0; i < tabArray.length; ++i) {
                for (int j = 0; j < tabArray.length; ++j) {
                    if (blArray[j] || !this.onTop[j].isEmpty()) continue;
                    tabArray[i] = this.tabs[j];
                    blArray[j] = true;
                    Integer n = i;
                    for (int n2 : this.onBottom[j]) {
                        this.onTop[n2].remove(n);
                    }
                    continue block0;
                }
            }
            return tabArray;
        }
    }

    public class LineSize
    extends TabsLayoutBlock.TabsSize {
        private boolean allTabs;

        public LineSize(Size.Type type, Dimension dimension, Tab[] tabArray, boolean bl) {
            super(LineTabsLayoutBlock.this, type, dimension, tabArray);
            this.allTabs = bl;
        }

        public boolean isAllTabs() {
            return this.allTabs;
        }
    }
}

