/*
 * Decompiled with CFR 0.152.
 */
package com.pensioenpage.jynx.ods2csv;

import com.pensioenpage.jynx.ods2csv.ConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public final class Converter {
    public void convert(InputStream in, OutputStream out) throws IllegalArgumentException, IOException, ConversionException {
        if (in == null) {
            throw new IllegalArgumentException("in == null");
        }
        if (out == null) {
            throw new IllegalArgumentException("out == null");
        }
        ZipInputStream zin = new ZipInputStream(in);
        ZipEntry entry = null;
        ZipEntry contentEntry = null;
        do {
            if ((entry = zin.getNextEntry()) == null || entry.isDirectory() || !"content.xml".equals(entry.getName())) continue;
            contentEntry = entry;
        } while (entry != null && contentEntry == null);
        if (contentEntry == null) {
            throw new ConversionException("Unable to find \"content.xml\" file entry in ZIP stream.");
        }
        new XMLParser(out).parse(zin);
    }

    private static class XMLParser
    extends DefaultHandler {
        private static final String OFFICE_NS = "urn:oasis:names:tc:opendocument:xmlns:office:1.0";
        private static final String TEXT_NS = "urn:oasis:names:tc:opendocument:xmlns:text:1.0";
        private static final String TABLE_NS = "urn:oasis:names:tc:opendocument:xmlns:table:1.0";
        private final Writer _out;
        private Throwable _exception;
        private boolean _insideRow;
        private boolean _insideCell;
        private boolean _insideCellText;
        private boolean _hadCells;
        private boolean _stringValueType;

        XMLParser(OutputStream out) throws IllegalArgumentException {
            if (out == null) {
                throw new IllegalArgumentException("out == null");
            }
            this._out = new OutputStreamWriter(out, Charset.forName("UTF-8"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void parse(InputStream in) throws IllegalArgumentException, ConversionException {
            Throwable cause;
            if (in == null) {
                throw new IllegalArgumentException("in == null");
            }
            try {
                XMLReader xmlReader = XMLReaderFactory.createXMLReader();
                xmlReader.setContentHandler(this);
                xmlReader.setErrorHandler(this);
                xmlReader.parse(new InputSource(in));
                cause = null;
            }
            catch (Throwable e) {
                cause = e;
            }
            Throwable throwable = cause = cause == null ? this._exception : cause;
            if (cause != null) {
                throw new ConversionException("Failed to process \"content.xml\" entry.", cause);
            }
            try {
                this._out.flush();
            }
            catch (Throwable e) {
            }
            finally {
                try {
                    this._out.close();
                }
                catch (Throwable e) {}
            }
        }

        public void warning(SAXParseException exception) {
        }

        public void error(SAXParseException exception) {
            this._exception = exception;
        }

        public void fatalError(SAXParseException exception) {
            this._exception = exception;
        }

        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if (TABLE_NS.equals(uri) && "table-row".equals(localName)) {
                this._insideRow = true;
                this._hadCells = false;
            } else if (TABLE_NS.equals(uri) && "table-cell".equals(localName) && this._insideRow) {
                String valueType;
                if (this._hadCells) {
                    this.output(',');
                }
                if ("float".equals(valueType = atts.getValue(OFFICE_NS, "value-type"))) {
                    this.output(atts.getValue(OFFICE_NS, "value"));
                    this._stringValueType = false;
                } else if ("date".equals(valueType)) {
                    this.output(atts.getValue(OFFICE_NS, "date-value"));
                    this._stringValueType = false;
                } else {
                    this._stringValueType = true;
                }
                this._insideCell = true;
            } else if (TEXT_NS.equals(uri) && "p".equals(localName) && this._insideCell) {
                this._insideCellText = true;
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (TABLE_NS.equals(uri) && "table-row".equals(localName) && this._insideRow) {
                this.output('\n');
                this._insideRow = false;
            } else if (TABLE_NS.equals(uri) && "table-cell".equals(localName) && this._insideCell) {
                this._insideCell = false;
                this._hadCells = true;
            } else if (TEXT_NS.equals(uri) && "p".equals(localName) && this._insideCellText) {
                this._insideCellText = false;
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (!this._insideCellText || !this._stringValueType) {
                return;
            }
            this.output('\"');
            int end = start + length;
            block3: for (int i = start; i < end; ++i) {
                char c = ch[i];
                switch (c) {
                    case '\"': {
                        this.output('\"');
                        this.output('\"');
                        continue block3;
                    }
                    default: {
                        this.output(c);
                    }
                }
            }
            this.output('\"');
        }

        private void output(char c) throws SAXException {
            try {
                this._out.write(c);
            }
            catch (IOException cause) {
                throw new SAXException("Failed to write character due to an I/O error.", cause);
            }
        }

        private void output(String s) throws SAXException {
            try {
                this._out.write(s, 0, s.length());
            }
            catch (IOException cause) {
                throw new SAXException("Failed to write character due to an I/O error.", cause);
            }
        }
    }
}

