/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.speedr.importwizard.tablemodel;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportTableModelHelper {
    private HashMap<Integer, File> columnfilemap = new HashMap();
    private HashMap<Integer, BufferedWriter> columnwritermap = new HashMap();

    public void saveRowDataSet(int line, String[] values) throws IOException {
        for (int i = 0; i < values.length; ++i) {
            BufferedWriter writer = this.columnwritermap.get(i);
            if (writer == null) {
                File temp = File.createTempFile(ImportTableModelHelper.class.getSimpleName(), ".col");
                temp.deleteOnExit();
                writer = new BufferedWriter(new FileWriter(temp));
                this.columnfilemap.put(i, temp);
                this.columnwritermap.put(i, writer);
            }
            writer.write(line + "\n");
            writer.write(values[i] + "\n");
        }
    }

    public void close() throws IOException {
        for (BufferedWriter writer : this.columnwritermap.values()) {
            writer.flush();
            writer.close();
        }
    }

    public List<String> getColumnData(int column) throws FileNotFoundException {
        ArrayList<String> data = new ArrayList<String>();
        Scanner scanner = new Scanner(this.columnfilemap.get(column));
        scanner.useDelimiter("\n");
        int row = 0;
        while (scanner.hasNextInt()) {
            int nextint = scanner.nextInt();
            while (row < nextint) {
                data.add(null);
                ++row;
            }
            data.add(scanner.next());
            ++row;
        }
        scanner.close();
        return data;
    }
}

