/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.speedr.importwizard.steps;

import at.ac.ait.speedr.WorkspaceView;
import at.ac.ait.speedr.importwizard.WizardPanel;
import at.ac.ait.speedr.importwizard.WizardValidationException;
import at.ac.ait.speedr.importwizard.steps.DataImportPanel;
import at.ac.ait.speedr.importwizard.steps.ImportTableModel;
import au.com.bytecode.opencsv.CSVReader;
import com.pensioenpage.jynx.ods2csv.Converter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CalcDataImportWizardStep
implements WizardPanel.ValidatingStep,
WizardPanel.ProgressStep,
PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(CalcDataImportWizardStep.class.getName());
    private DataImportPanel impPanel;
    private WizardPanel settings;
    private volatile boolean isStopped = false;
    private boolean valid = false;
    private File dataFile;
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);

    public DataImportPanel getComponent() {
        if (this.impPanel == null) {
            this.impPanel = new DataImportPanel(false);
            this.impPanel.addPropertyChangeListener(this);
        }
        return this.impPanel;
    }

    public void readSettings(WizardPanel settings) {
        this.settings = settings;
        if (settings.getProperty("PROP_DATASOURCE") == "PROP_FILE_DATASOURCE") {
            this.getComponent().setConfigurationPanelEnabled(false);
            this.dataFile = (File)settings.getProperty("PROP_FILE");
        }
    }

    public void storeSettings(WizardPanel settings) {
        settings.putProperty("VARIABLENAME", this.getComponent().getVariableName());
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean b) {
        this.valid = b;
        this.fireChangeEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator<ChangeListener> it;
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            it = new HashSet<ChangeListener>(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            it.next().stateChanged(ev);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == "VARIABLENAME") {
            String varname = this.getComponent().getVariableName();
            if (varname.equals("") || Character.isDigit(varname.charAt(0)) || !varname.equals(varname.replaceAll("[ -+*/\\()=!~`@#$%^&*<>,?;:\"']", "."))) {
                this.settings.putProperty("WizardPanel_errorMessage", "invalid variable name");
                this.setValid(false);
            } else {
                this.settings.putProperty("WizardPanel_errorMessage", null);
                this.setValid(true);
            }
        }
    }

    public void validate() throws WizardValidationException {
        int showConfirmDialog;
        String varname = this.getComponent().getVariableName();
        if (varname == null || varname.trim().equals("")) {
            throw new WizardValidationException("Please set a variable name");
        }
        if (WorkspaceView.getInstance().hasVariable(varname) && (showConfirmDialog = JOptionPane.showConfirmDialog(this.getComponent(), "A variable with the name " + varname + " exsists already!\n" + "Do you want to replace it?")) != 0) {
            throw new WizardValidationException("Variable name exists");
        }
    }

    public void startProcessing() {
        this.isStopped = false;
        try {
            PipedOutputStream pOut = new PipedOutputStream();
            PipedInputStream pIn = new PipedInputStream(pOut, 16384);
            CalcProcessor excelProcessor = new CalcProcessor(pOut, this.dataFile);
            excelProcessor.start();
            CSVReaderWorker worker = new CSVReaderWorker(pIn, this.getComponent().getTableModel());
            worker.execute();
            worker.get();
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, ex.getMessage(), ex);
            this.settings.putProperty("WizardPanel_errorMessage", ex.getMessage());
        }
    }

    public void stopProcessing() {
        this.isStopped = true;
    }

    private void outOfMemoryHandle() {
        this.isStopped = true;
        this.settings.putProperty("WizardPanel_warningMessage", "Out of available memory!");
        JOptionPane.showMessageDialog(this.impPanel, "Out of memory!\nPlease restart R and call speedR with an increased value in Mb!");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CSVReaderWorker
    extends SwingWorker<Object, String[]> {
        private InputStream in;
        private ImportTableModel tableModel;
        private boolean gcCalled = false;

        public CSVReaderWorker(InputStream in, ImportTableModel tableModel) {
            this.in = in;
            this.tableModel = tableModel;
        }

        @Override
        protected Object doInBackground() throws Exception {
            try {
                String[] next;
                CSVReader csvReader = new CSVReader((Reader)new InputStreamReader(this.in), ',', '\"');
                while (!CalcDataImportWizardStep.this.isStopped && (next = csvReader.readNext()) != null) {
                    this.publish((V[])new String[][]{next});
                }
                this.in.close();
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, ex.getMessage(), ex);
                CalcDataImportWizardStep.this.settings.putProperty("WizardPanel_errorMessage", ex.getMessage());
            }
            catch (OutOfMemoryError err) {
                CalcDataImportWizardStep.this.outOfMemoryHandle();
            }
            return null;
        }

        @Override
        protected void process(List<String[]> chunks) {
            try {
                this.tableModel.addRow(chunks);
            }
            catch (OutOfMemoryError err) {
                CalcDataImportWizardStep.this.outOfMemoryHandle();
            }
        }

        @Override
        protected void done() {
            CalcDataImportWizardStep.this.setValid(true);
            CalcDataImportWizardStep.this.getComponent().setConfigurationPanelEnabled(true);
        }
    }

    private class CalcProcessor
    extends Thread {
        private PipedOutputStream pOut;
        private File calcFile;

        public CalcProcessor(PipedOutputStream pOut, File calcFile) {
            this.pOut = pOut;
            this.calcFile = calcFile;
        }

        public void run() {
            try {
                new Converter().convert((InputStream)new BufferedInputStream(new FileInputStream(this.calcFile)), (OutputStream)this.pOut);
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
    }
}

