/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.speedr;

import at.ac.ait.speedr.SpeedRFrame;
import at.ac.ait.speedr.table.model.onedim.RDoubleTableModel;
import at.ac.ait.speedr.table.model.onedim.RIntegerTableModel;
import at.ac.ait.speedr.table.model.onedim.RStringTableModel;
import at.ac.ait.speedr.table.model.twodim.RDataFrameTableModel;
import at.ac.ait.speedr.table.model.twodim.RDoubleMatrixTableModel;
import at.ac.ait.speedr.table.model.twodim.RIntegerMatrixTableModel;
import at.ac.ait.speedr.table.model.twodim.RStringMatrixTableModel;
import at.ac.ait.speedr.workspace.RObject;
import at.ac.ait.speedr.workspace.Workspace;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPDouble;
import org.rosuda.REngine.REXPGenericVector;
import org.rosuda.REngine.REXPInteger;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REXPString;
import org.rosuda.REngine.REngineException;

public class WorkspaceView
extends JPanel {
    private static WorkspaceView instance;
    private Workspace workspace;
    private SpeedRFrame mainFrame;
    private JScrollPane jScrollPane1;
    private JTree workspaceTree;

    public WorkspaceView(SpeedRFrame mainFrame) {
        instance = this;
        this.mainFrame = mainFrame;
        this.workspace = new Workspace();
        this.initComponents();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.workspaceTree = new JTree();
        this.jScrollPane1.setBorder(null);
        this.workspaceTree.setModel(this.workspace.getWorkspace());
        this.workspaceTree.getSelectionModel().setSelectionMode(1);
        this.workspaceTree.addTreeWillExpandListener(new TreeWillExpandListener(){

            public void treeWillCollapse(TreeExpansionEvent evt) throws ExpandVetoException {
            }

            public void treeWillExpand(TreeExpansionEvent evt) throws ExpandVetoException {
                WorkspaceView.this.workspaceTreeTreeWillExpand(evt);
            }
        });
        this.workspaceTree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                WorkspaceView.this.workspaceTreeMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.workspaceTree);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 74, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 275, Short.MAX_VALUE));
    }

    private void workspaceTreeMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            try {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.workspaceTree.getLastSelectedPathComponent();
                if (node != this.workspace.getWorkspace().getRoot()) {
                    RObject ro = (RObject)node.getUserObject();
                    REXP content = this.workspace.loadContent(ro.getRSymbol());
                    int[] dim = content.dim();
                    if (dim == null) {
                        if (ro.getType().equals("data.frame")) {
                            this.openTwoDimensionalTable(ro, content);
                        } else {
                            this.openOneDimensionalTable(ro, content);
                        }
                    } else if (dim.length == 1) {
                        this.openOneDimensionalTable(ro, content);
                    } else if (dim.length == 2) {
                        this.openTwoDimensionalTable(ro, content);
                    }
                }
            }
            catch (REngineException ex) {
                Logger.getLogger(WorkspaceView.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (REXPMismatchException ex) {
                Logger.getLogger(WorkspaceView.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void workspaceTreeTreeWillExpand(TreeExpansionEvent evt) throws ExpandVetoException {
        TreePath p = evt.getPath();
        if (!this.workspaceTree.hasBeenExpanded(p)) {
            try {
                DefaultMutableTreeNode n = (DefaultMutableTreeNode)p.getLastPathComponent();
                this.workspace.addListChildren(n);
            }
            catch (Exception ex) {
                Logger.getLogger(WorkspaceView.class.getName()).log(Level.SEVERE, null, ex);
                JOptionPane.showMessageDialog(this.workspaceTree, "Can not load list children!\n" + ex.getMessage(), "Error", 0);
            }
        }
    }

    private void openOneDimensionalTable(RObject ro, REXP content) throws REXPMismatchException {
        AbstractTableModel model = null;
        if (content.isInteger()) {
            model = new RIntegerTableModel((REXPInteger)content);
        } else if (content.isNumeric()) {
            model = new RDoubleTableModel((REXPDouble)content);
        } else if (content.isString() || content.isFactor()) {
            model = new RStringTableModel((REXPString)content);
        }
        if (model != null) {
            this.mainFrame.openTable(model, ro.getName());
        }
    }

    private void openTwoDimensionalTable(RObject ro, REXP content) throws REXPMismatchException {
        if (ro.getType().equals("data.frame")) {
            RDataFrameTableModel model = new RDataFrameTableModel((REXPGenericVector)content);
            this.mainFrame.openTable(model, ro.getName());
        } else if (ro.getType().equals("matrix") || ro.getType().equals("table") || ro.getType().equals("array")) {
            AbstractTableModel model = null;
            if (content.isInteger()) {
                model = new RIntegerMatrixTableModel((REXPInteger)content);
            } else if (content.isNumeric()) {
                model = new RDoubleMatrixTableModel((REXPDouble)content);
            } else if (content.isString()) {
                model = new RStringMatrixTableModel((REXPString)content);
            }
            if (model != null) {
                this.mainFrame.openTable(model, ro.getName());
            }
        }
    }

    public void reload() throws REngineException, REXPMismatchException {
        this.workspace.reload();
    }

    public boolean hasVariable(String varname) {
        return this.workspace.hasVariable(varname);
    }

    public static WorkspaceView getInstance() {
        return instance;
    }
}

