% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_functions.R
\name{plot_interactive}
\alias{plot_interactive}
\title{Plot spectra interactively}
\usage{
plot_interactive(spec, colpalette = function(n) RColorBrewer::brewer.pal(n,
  "Dark2"), ...)
}
\arguments{
\item{spec}{spectra object}

\item{colpalette}{a color palette function, e.g. rainbow, terrain.colors, or a
function returned by colorRampPalette() or colorRamps package}

\item{...}{Other arguments passed to plot}
}
\value{
interactive plot
}
\description{
Interactively plots spectra with a shiny app. Useful to inspect large datasets.
}
\details{
\code{plot_interact} limits the number of spectra displayed at once to 600 for
performance reasons. As of now, the function does not return anything and does
not have side effects. This means that spectra can be selected and highlighted
but not yet deleted or subset from the shiny app.
}
\examples{
\dontrun{
# Create a spectra object
spec = as.spectra(spec_matrix_example)

# Start interactive plot
plot_interactive(spec)
}
}
\author{
Anna K. Schweiger and Jose Eduardo Meireles
}
