% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.spc.modified.R
\name{read_spc_nosubhdr}
\alias{read_spc_nosubhdr}
\title{Import for Thermo Galactic's spc file format
These functions allow to import .spc files.}
\usage{
read_spc_nosubhdr(filename, keys.hdr2data = c("fexper", "fres", "fsource"),
  keys.hdr2log = c("fdate", "fpeakpt"), keys.log2data = FALSE,
  keys.log2log = TRUE, log.txt = TRUE, log.bin = FALSE,
  log.disk = FALSE, hdr = list(), no.object = FALSE)
}
\arguments{
\item{filename}{The complete file name of the .spc file.}

\item{keys.hdr2data, keys.hdr2log, keys.log2data, keys.log2log}{character
  vectors with the names of parameters in the .spc file's log block
  (log2xxx) or header (hdr2xxx) that should go into the extra data
  (yyy2data) or into the \code{long.description} field of the returned
  hyperSpec object's log (yyy2log).

All header fields specified in the .spc file format specification (see
  below) are imported and can be referred to by their de-capitalized names.}

\item{log.txt}{Should the text part of the .spc file's log block be read?}

\item{log.bin, log.disk}{Should the normal and on-disk binary parts of the
.spc file's log block be read?  If so, they will be put as raw vectors
into the hyperSpec object's log.}

\item{hdr}{A list with fileheader fields that overwrite the settings of
  actual file's header.

Use with care, and look into the source code for detailed insight on the
  elements of this list.}

\item{no.object}{If \code{TRUE}, a list with wavelengths, spectra, labels,
  log and data are returned instead of a hyperSpec object.

This parameter will likely be subject to change in future - use with care.}

}
\value{
If the file contains multiple spectra with individual wavelength
  axes, \code{read.spc} returns a list of hyperSpec objects.  Otherwise the
  result is a hyperSpec object.

\code{read.spc.KaiserMap} returns a hyperSpec object with data columns x,
  y, and z containing the stage position as recorded in the .spc files'
  log.
}
\description{
Import for Thermo Galactic's spc file format
These functions allow to import .spc files.
}
\note{
Only a restricted set of test files was available for development.
  Particularly, the w-planes feature could not be tested.

If you have .spc files that cannot be read with these function, don't
  hesitate to contact the package maintainer with your code patch or asking
  advice.
}

\seealso{
\code{\link[hyperSpec]{textio}}
}
\author{
C. Beleites
}
\keyword{IO}
\keyword{file}
