% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{plotCurve}
\alias{plotCurve}
\title{Plots a specification curve.}
\usage{
plotCurve(
  sca_data,
  title = "",
  showIndex = TRUE,
  plotVars = TRUE,
  ylab = "Coefficient",
  plotSE = "bar"
)
}
\arguments{
\item{sca_data}{A data frame returned by `sca()` containing model estimates
from the specification curve analysis.}

\item{title}{A string to use as the plot title. Defaults to an empty string,
`""`.}

\item{showIndex}{A boolean indicating whether to label the model index on the
the x-axis. Defaults to `TRUE`.}

\item{plotVars}{A boolean indicating whether to include a panel on the plot
showing which variables are present in each model. Defaults
to `TRUE`.}

\item{ylab}{A string to be used as the y-axis label. Defaults to
`"Coefficient"`.}

\item{plotSE}{A string indicating whether to display standard errors as
bars or plots. For bars `plotSE = "bar"`, for ribbons
`plotSE = "ribbon"`. If any other value is supplied then no
standard errors are included. Defaults to `"bar"`.}
}
\value{
If `plotVars = TRUE` returns a grid grob (i.e. the output of a call
        to `grid.draw`). If `plotVars =  FALSE` returns a ggplot object.
}
\description{
plotCurve() takes the data frame output of sca() and produces a ggplot of
the independent variable's coefficient (as indicated in the call to sca())
across model specifications. By default a panel is added showing which
control variables are present in each model. Note that the ggplot output by
this function can only be further customized when `plotVars = FALSE`, i.e.
when the control variable panel is not included.
}
\examples{
plotCurve(sca_data = sca(y="Salnty", x="T_degC", c("ChlorA", "O2Sat"),
                         data=bottles, progressBar=TRUE, parallel=FALSE),
                     title = "Salinity and Temperature Models",
                     showIndex = TRUE, plotVars = TRUE,
                     ylab = "Coefficient value", plotSE = "ribbon");
plotCurve(sca_data = sca(y="Salnty", x="T_degC", c("ChlorA*O2Sat"),
                         data=bottles, progressBar=FALSE, parallel=FALSE),
                     showIndex = TRUE, plotVars = TRUE,
                     plotSE = "ribbon");
plotCurve(sca_data = sca(y="Salnty", x="T_degC",
                         c("ChlorA*NO3uM", "O2Sat*NO3uM"), data=bottles,
                         progressBar = TRUE, parallel = TRUE, workers=2),
          plotSE="");
}
