% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HMDBsearchR.R
\name{HMDBsearchR}
\alias{HMDBsearchR}
\title{Submit 1H NMR peaks to HMDB for compound search}
\usage{
HMDBsearchR(peakVector, ppmTol = 0.02, returnURL = FALSE)
}
\arguments{
\item{peakVector}{A vector with ppm values of peaks}

\item{ppmTol}{The ppm tolerance for the HMDB search (default = 0.02).}

\item{returnURL}{Return the URL instead of opening a webpage.}
}
\value{
Opens a webpage or returns a URL with the HMDB results
}
\description{
This function allows to search HMDB from within R by simply submitting the peaks you want to search for. 
The function will open a webpage with the query results or provide a link to the HMDB page with the results.
}
\examples{
\dontrun{
HMDBsearchR(peakVector = c(3.2, 3.38), ppmTol = 0.2, returnURL = TRUE)
}

}
\author{
Charlie Beirnaert, \email{charlie.beirnaert@uantwerpen.be}
}
