% Copyright 2001 by Nicholas Lewin-Koh
\name{graphneigh}
\alias{gabrielneigh}
\alias{relativeneigh}
\alias{soi.graph}
\alias{plot.Gabriel}
\alias{plot.relative}
\alias{graph2nb}


\title{Graph based spatial weights}
\description{
Functions return a graph object containing a list with the vertex
coordinates and the to and from indices defining the edges. The helper
function \code{graph2nb} converts a graph
object into a neighbour list. The plot functions plot the graph objects.
}
\usage{
gabrielneigh(coords)
relativeneigh(coords)
%beta.skel(coords,beta)
soi.graph(tri.nb, coords)
graph2nb(gob, row.names=NULL,sym=FALSE)
plot.Gabriel(x, show.points=FALSE, add=FALSE, linecol=par(col), ...)
plot.relative(x, show.points=FALSE, add=FALSE, linecol=par(col),...)
}

\arguments{
  \item{coords}{matrix of region point coordinates}
  \item{tri.nb}{a neighbor list created from tri2nb}
%  \item{beta}{the parameter for a beta skeleton}
  \item{gob}{a graph object created from any of the graph funtions}
  \item{row.names}{character vector of region ids to be added to the
    neighbours list as attribute \code{region.id}, default \code{seq(1,
      nrow(x))}}
  \item{sym}{a logical argument indicating whether or not neighbors
    should be symetric (if i->j then j->i)}
  \item{x}{object to be plotted}
  \item{show.points}{(logical) add points to plot}
  \item{add}{(logical) add to existing plot}
  \item{linecol}{edge plotting colour}
  \item{...}{further graphical parameters as in \code{par(..)}}
}
\details{
The graph functions produce graphs on a 2d point set that
%except for
%some values of \eqn{ \beta (\beta < 1)}{\beta (\beta < 1)} in the
%beta-skeleton, 
are all subgraphs of the Delaunay triangulation. The
relative neighbor graph is defined by the relation, x and y are neighbors if

\deqn{d(x,y) \le min(max(d(x,z),d(y,z))| z \in S)}{d(x,y) <= min(max(d(x,z),d(y,z))| z in S)}

where d() is the distance, S is the set of points and z is an arbitrary
point in S. The Gabriel graph is a subgraph of the delaunay
triangulation and has the relative neighbor graph as a sub-graph. The
relative neighbor graph is defined by the relation x and y are Gabriel
neighbors if

\deqn{d(x,y) \le min((d(x,z)^2 + d(y,z)^2)^{1/2} |z \in S)}{d(x,y) <= min((d(x,z)^2 + d(y,z)^2)^1/2 |z in S)}

where x,y,z and S are as before. The sphere of influence graph is
defined for a finite point set S, let \eqn{r_x} be the distance from point x
to its nearest neighbor in S, and \eqn{C_x} is the circle centered on x. Then
x and y are SOI neigbors iff \eqn{C_x} and \eqn{C_y} intersect in at
least 2 places.

%The \eqn{beta}{\beta} 
}
\value{
A list of class \code{Graph} withte following elements
  \item{np}{number of input points}
  \item{from}{array of origin ids}
  \item{to}{array of destination ids}
  \item{nedges}{number of edges in graph}
  \item{x}{input x coordinates}
  \item{y}{input y coordinates}
The helper functions return an \code{nb} object with a list of integer
 vectors containing neighbour region number ids.
}

\references{
  Matula, D. W. and Sokal R. R. 1980, Properties of Gabriel
  graphs relevant to geographic variation research and the clustering of
  points in the plane, Geographic Analysis, 12(3), pp. 205-222.

  Toussaint, G. T. 1980, The relative neighborhood graph of a finite
  planar set, Pattern Recognition, 12(4), pp. 261-268.

  Kirkpatrick, D. G. and Radke, J. D. 1985, A framework for
  computational morphology. In Computational Geometry,
  Ed. G. T. Toussaint, North Holland.

  
  }

\author{Nicholas Lewin-Koh \email{nikko@hailmail.net}}

\seealso{\code{\link{knearneigh}}, \code{\link{dnearneigh}},
\code{\link{knn2nb}}}

\examples{
example(columbus)
coords <- coordinates(columbus)
par(mfrow=c(2,2))
col.tri.nb<-tri2nb(coords)
col.gab.nb<-graph2nb(gabrielneigh(coords), sym=TRUE)
col.rel.nb<- graph2nb(relativeneigh(coords), sym=TRUE)
col.soi.nb<- graph2nb(soi.graph(col.tri.nb,coords), sym=TRUE)
plot(columbus, border="grey")
plot(col.tri.nb,coords,add=TRUE)
title(main="Delaunay Triangulation")
plot(columbus, border="grey")
plot(col.gab.nb, coords, add=TRUE)
title(main="Gabriel Graph")
plot(columbus, border="grey")
plot(col.rel.nb, coords, add=TRUE)
title(main="Relative Neighbor Graph")
plot(columbus, border="grey")
plot(col.soi.nb, coords, add=TRUE)
title(main="Sphere of Influence Graph")
par(mfrow=c(1,1))
}
\keyword{spatial}
