% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/SPCA_Functions_forcard.R
\name{choosecard}
\alias{choosecard}
\title{Function for choosing the cardinality of the sparse components}
\usage{
choosecard(S, method = c("BE", "BB"), perc = TRUE, unc = TRUE, trim = 1,
  reducetrim = TRUE, prntrace = FALSE, cardstoprint, interact = TRUE,
  rtntrace = TRUE, doplot = TRUE, plotminload = TRUE,
  plotcvexp = c("rel", "abs", FALSE), plotlovsvexp = TRUE,
  plotentropy = TRUE, plotfarcomeni = FALSE, mfrowplot = 2,
  mfcolplot = 2, cardstoplot, ce = 1)
}
\arguments{
\item{S}{A correlation (or covariance) matrix.}

\item{method}{String. Method used to produce solutions, either BE or BB.}

\item{perc}{Logical: should the loading be scaled as percentages?}

\item{unc}{Logical vector. If TRUE the corresponding component is computed
uncorrelated, otherwise correlated. Can be shorter than nd. See details for
\link{spcabe}.}

\item{trim}{Number of loadings to trim at each iteration.  See details for
\link{spcabe}}

\item{reducetrim}{Logical. If TRUE and trim > 1 when are left less than trim
+ mincard[j] loadings, trim is reduced to 1 for these last loadings.}

\item{prntrace}{Logical: should the trace of the trimming be printed?}

\item{cardstoprint}{Integer: number of cardinalities to print with the
trace. If missing all, otherwise only the last \emph{cardstoprint} solutions
will be printed.}

\item{interact}{Hybrid: if TRUE the cardinalities chosen must be entered
intearctively.  If a vector of cardinalities is passed the plots and tracies
are produced.}

\item{rtntrace}{Logical: should the trace of the trimming be returned?}

\item{doplot}{Logical: should the any plotting be done}

\item{plotminload}{Logical: should the minimum loading (or contribution if
perc = TRUE) for each cardinality be plotted?}

\item{plotcvexp}{string: if set =\emph{abs} the percentage variance
explained for each cardinality is plotted. If set =\emph{rel} the percentage
cumulative variance explained relative to that explained by the same number
of PCs is plotted against the cardinality. If set =FALSE (or anything else)
none is plotted.}

\item{plotlovsvexp}{Logical: should the variance explained for each
cardinality be plotted against the minimal loadings?}

\item{plotentropy}{Logical: should the entropy of the loadings be plotted?}

\item{plotfarcomeni}{Logical: should the sparsity index proposed by
farcomeni be plotted?}

\item{mfrowplot,mfcolplot}{Integers. The number of rows and columns on which
display the plots}

\item{cardstoplot}{Integer: number of cardinalities to plot. If missing all
are plotted}

\item{ce}{Real > 0. The expansion factor for the plots labels.}
}
\value{
If rtntrace = TRUE a list of matrices of full traces is retuned.
}
\description{
Interactive function that produces and plots various statistics relative to
different cardinalities of the sparse components.
}
\details{
This function is interactive produces plots relative to the different
cardinalities of a component and then asks which cardinality is preferred
and computes the next. The process can be stopped by entering adding a
decimal value to cardinality of the last component desired. By default the
solutions are computed with the BE algorithm (\code{\link{spcabe}}).
\emph{prntrace=TRUE} prints the trace of the last \emph{cardstoprint}
trimmings, with the variables orderd in elimination order during cardinality
selection.  The order may not be univocal when using the BB algorithm.
\emph{rtntrace} returns the full trace for all dimensions.  The default
settings produce 4 plots. Farcomeni's index is computed as \eqn{vexp(c_j) -
\frac{\log(c_j)\bar\sigma^2}{j+1}}, where \eqn{c_j}{c_j} is the cardinality
and \eqn{\bar\sigma^2} is the average variance (=1 for correlation
matrices). The values of farcomeni's Index and entropy are not returned if
their plot is not required.
}
\note{
The plots are not very customisable. Personalised plots can be easily
produced from the spca object.
}
\examples{
\dontrun{
data(bsbl)
## run choosecard in non interactive mode
ba <- choosecard(bsbl, prntrace = TRUE, cardstoprint = 6, doplot = FALSE, interact = c(3, 3, 4))

# to run in interactive mode replace the interact and doplot arguments with TRUE
# (or remove them from the call altogether).
}
}
\references{
Giovanni M. Merola. 2014.  Least Squares Sparse Principal
Component Analysis: a backward elimination approach to attain large
loadings. To appear in Australian and New Zealand Journal of Statistics.
}
\seealso{
\code{\link{spcabe}}, \code{\link{spcabb}}.
}

