\name{rshift.psp}
\alias{rshift.psp}
\title{Randomly Shift a Line Segment Pattern}
\description{
  Randomly shifts the segments in a line segment pattern.
}
\usage{
   \method{rshift}{psp}(X, \dots, group=NULL, which=NULL)
}
\arguments{
  \item{X}{Line segment pattern to be subjected to a random shift.
    An object of class \code{"psp"}.
  }
  \item{\dots}{
    Arguments controlling the randomisation and the handling of edge
    effects. See \code{\link{rshift.ppp}}.
  }
  \item{group}{
    Optional. Factor specifying a grouping of the line segments of \code{X},
    or \code{NULL} indicating that all line segments belong to the same group.
    Each group will be shifted together, and
    separately from other groups.
  }
  \item{which}{
    Optional. Identifies which groups of the pattern will be shifted,
    while other groups are not shifted. A vector of levels of \code{group}.
  }
}
\value{
  A line segment pattern (object of class \code{"psp"}).
}
\details{
  This operation randomly shifts the locations of the line segments
  in a line segment pattern.

  The function \code{rshift} is generic. This function \code{rshift.psp}
  is the method for line segment patterns.

  The line segments of \code{X} are first divided into groups,
  then the line segments within a group are shifted by a common
  random displacement vector. Different groups of line segments are shifted
  independently.
  If the argument \code{group} is present, then this determines the grouping.
  Otherwise, all line segments belong to a single group.

  The argument \code{group} should be a factor, of length equal to the
  number of line segments in \code{X}.
  Alternatively \code{group} may be \code{NULL},
  which specifies that all line segments of \code{X} belong to a single group.

  By default, every group of line segments will be shifted.
  The argument \code{which} indicates that only some of the groups
  should be shifted, while other groups should be left unchanged.
  \code{which} must be a vector of levels of \code{group}
  indicating which groups are to be shifted. 

  The displacement vector, i.e. the vector
  by which the data line segments are shifted,
  is generated at random.
  The \emph{default} behaviour is 
  to generate a displacement vector at random with equal probability
  for all possible displacements. This means that the \eqn{x} and
  \eqn{y} coordinates of the displacement vector are independent random
  variables, uniformly distributed over the range of possible coordinates.

  Alternatively, the displacement vector can be generated by
  another random mechanism, controlled by the arguments
  \code{radius}, \code{width} and \code{height}. 
  \describe{
    \item{rectangular:}{
      if \code{width} and \code{height} are given, then 
      the displacement vector is uniformly distributed
      in a rectangle of these dimensions, centred at
      the origin.  The maximum possible displacement in the \eqn{x}
      direction is \code{width/2}. The maximum possible displacement in
      the \eqn{y} direction is \code{height/2}. The \eqn{x} and \eqn{y}
      displacements are independent. (If \code{width} and \code{height}
      are actually equal to the dimensions of the observation window,
      then this is equivalent to the default.)
    }
    \item{radial:}{
      if \code{radius} is given, then the displacement vector is
      generated by choosing a random line segment inside a disc of
      the given radius, centred at the origin, with uniform probability
      density over the disc. Thus the argument \code{radius} determines
      the maximum possible displacement distance.
      The argument \code{radius} is incompatible with the
      arguments \code{width} and \code{height}.
    }
  }

  The argument \code{edge} controls what happens when 
  a shifted line segment lies partially or completely
  outside the window of \code{X}. Currently the only option is
  \code{"erode"} which specifies that the segments will be clipped
  to a smaller window. 

  The optional argument \code{clip} specifies a smaller window
  to which the pattern should be restricted.
}
\seealso{
  \code{\link{rshift}},
  \code{\link{rshift.ppp}}
}
\examples{
  X <- psp(runif(20), runif(20), runif(20), runif(20),  window=owin())
  Y <- rshift(X, radius=0.1)
}
\author{Adrian Baddeley \email{Adrian.Baddeley@curtin.edu.au}
  
  
  and Rolf Turner \email{r.turner@auckland.ac.nz}
  
}
\keyword{spatial}
\keyword{datagen}

