% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial_clustering_cv.R
\name{spatial_clustering_cv}
\alias{spatial_clustering_cv}
\title{Spatial or Cluster Cross-Validation}
\usage{
spatial_clustering_cv(data, coords, v = 10, ...)
}
\arguments{
\item{data}{A data frame.}

\item{coords}{A vector of variable names, typically spatial coordinates,
to partition the data into disjointed sets via k-means clustering.}

\item{v}{The number of partitions of the data set.}

\item{...}{Extra arguments passed on to \code{\link[stats:kmeans]{stats::kmeans()}}.}
}
\value{
A tibble with classes \code{spatial_cv}, \code{rset}, \code{tbl_df}, \code{tbl}, and
\code{data.frame}. The results include a column for the data split objects and
an identification variable \code{id}.
}
\description{
Spatial or cluster cross-validation splits the data into V groups of
disjointed sets using k-means clustering of some variables, typically
spatial coordinates. A resample of the analysis data consists of V-1 of the
folds/clusters while the assessment set contains the final fold/cluster. In
basic spatial cross-validation (i.e. no repeats), the number of resamples
is equal to V.
}
\details{
The variables in the \code{coords} argument are used for k-means clustering of
the data into disjointed sets, as outlined in Brenning (2012). These
clusters are used as the folds for cross-validation. Depending on how the
data are distributed spatially, there may not be an equal number of points
in each fold.
}
\examples{
data(ames, package = "modeldata")
spatial_clustering_cv(ames, coords = c(Latitude, Longitude), v = 5)

}
\references{
A. Brenning, "Spatial cross-validation and bootstrap for the assessment of
prediction rules in remote sensing: The R package sperrorest," 2012 IEEE
International Geoscience and Remote Sensing Symposium, Munich, 2012,
pp. 5372-5375, doi: 10.1109/IGARSS.2012.6352393.
}
