% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ripleys_k.R
\name{ripleys_k}
\alias{ripleys_k}
\title{Calculate Count Based Measures of Spatial Clustering for IF data}
\usage{
ripleys_k(
  mif,
  mnames,
  r_range = seq(0, 100, 50),
  num_permutations = 50,
  edge_correction = "translation",
  method = "K",
  keep_perm_dis = FALSE,
  workers = 1,
  overwrite = FALSE,
  xloc = NULL,
  yloc = NULL
)
}
\arguments{
\item{mif}{An MIF object}

\item{mnames}{Character vector of marker names to estimate degree of
spatial clustering.}

\item{r_range}{Numeric vector of potential r values this range must include 0.}

\item{num_permutations}{Numeric value indicating the number of permutations used.
Default is 50.}

\item{edge_correction}{Character value indicating the type of edge correction
to use. Options include "translation" or "isotropic".}

\item{method}{Character value indicating which measure (K, L, M) used to
estimate the degree of spatial clustering. Description of the methods can be
found in Details section.}

\item{keep_perm_dis}{Logical value determining whether or not to keep the full
distribution of permuted K values}

\item{workers}{Integer value for the number of workers to spawn}

\item{overwrite}{Logical value determining if you want the results to replace the
current output (TRUE) or be to be appended (FALSE).}

\item{xloc}{a string corresponding to the x coordinates. If null the average of
XMin and XMax will be used}

\item{yloc}{a string corresponding to the y coordinates. If null the average of
YMin and YMax will be used}
}
\value{
Returns a data.frame
\item{Theoretical CSR}{Expected value assuming complete spatial randomnessn}
\item{Permuted CSR}{Average observed K, L, or M for the permuted point
process}
\item{Observed}{Observed valuefor the observed point process}
\item{Degree of Clustering Permuted}{Degree of spatial clustering where the
reference is the permutated estimate of CSR}
\item{Degree of Clustering Theoretical}{Degree of spatial clustering where the
reference is the theoretical estimate of CSR}
}
\description{
This function calculates count based Measures (Ripley's K, Besag
L, and Marcon's M) of IF data to characterize correlation of spatial point
process.
}
\examples{
#Create mif object
library(dplyr)
x <- create_mif(clinical_data = example_clinical \%>\% 
mutate(deidentified_id = as.character(deidentified_id)),
sample_data = example_summary \%>\% 
mutate(deidentified_id = as.character(deidentified_id)),
spatial_list = example_spatial,
patient_id = "deidentified_id", 
sample_id = "deidentified_sample")

# Define the set of markers to study
markers <- c("CD3..Opal.570..Positive","CD8..Opal.520..Positive",
"FOXP3..Opal.620..Positive","CD3..CD8.","CD3..FOXP3.")

# Ripley's K for all markers with a neighborhood size 
# of  10,20,...,100 (zero must be included in the input).

x <- ripleys_k(mif = x, mnames = markers, num_permutations = 1,
edge_correction = 'translation', r = seq(0,100,10),
keep_perm_dis = FALSE, workers = 1)

}
