% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runFunctions.R
\name{spathialWay}
\alias{spathialWay}
\title{Compute Principal Path}
\usage{
spathialWay(X, boundary_ids, NC = 50)
}
\arguments{
\item{X}{data points}

\item{boundary_ids}{starting and ending points}

\item{NC}{number of waypoints}
}
\value{
spathial_res: spathial waypoints
}
\description{
Get the coordinates of the waypoints of the principal path
}
\examples{
#EXAMPLE 1
# Load data matrix X
load(system.file('extdata','X.rda',package='spathial',mustWork=TRUE))
# Load description vector X_labels
load(system.file('extdata','X_labels.rda',package='spathial',mustWork=TRUE))
# Run spathialBoundary
boundaryRes <- spathialBoundaryIds(X, X_labels, mode=2, from=3, to=6)
X <- boundaryRes$X
X_labels <- boundaryRes$X_labels
boundary_ids <- boundaryRes$boundary_ids
#Set the number of waypoints
NC <- 20
# Run spathialWay
spathial_res <- spathialWay(X, boundary_ids, NC)
spathial_res
}
