% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aleatory_analysis.R
\name{aa_getATestResults_overTime}
\alias{aa_getATestResults_overTime}
\title{Get A-Test results for multiple simulation timepoints}
\usage{
aa_getATestResults_overTime(FILEPATH, SAMPLESIZES, NUMSUBSETSPERSAMPLESIZE,
  MEASURES, ATESTRESULTSFILENAME, LARGEDIFFINDICATOR,
  AA_SIM_RESULTS_FILE = NULL, AA_SIM_RESULTS_OBJECT = NULL, TIMEPOINTS,
  TIMEPOINTSCALE, GRAPHNAME = NULL)
}
\arguments{
\item{FILEPATH}{Directory where the results of the simulation runs, in folders or in single CSV file format, can be found}

\item{SAMPLESIZES}{The sample sizes chosen (i.e. in our case, this would be an array containing 1,5,50,100,300,800}

\item{NUMSUBSETSPERSAMPLESIZE}{The number of subsets for each sample size (i.e in the tutorial case, 20)}

\item{MEASURES}{An array containing the names of the simulation output measures to be analysed.}

\item{ATESTRESULTSFILENAME}{Name of the file that will contain the A-Test scores for each sample size}

\item{LARGEDIFFINDICATOR}{The A-Test determines there is a large difference between two sets if the result is greater than 0.2 either side of the 0.5 line.  Should this not be suitable, this can be changed here}

\item{AA_SIM_RESULTS_FILE}{The name of the CSV file containing the simulation responses, if reading from a CSV file}

\item{AA_SIM_RESULTS_OBJECT}{The name of the R object containing the simulation responses, if not reading from a CSV file}

\item{TIMEPOINTS}{Implemented so this method can be used when analysing multiple simulation timepoints. If only analysing one timepoint, this should be set to NULL. If not, this should be an array of timepoints, e.g. c(12,36,48,60)}

\item{TIMEPOINTSCALE}{Implemented so this method can be used when analysing multiple simulation timepoints. Sets the scale of the timepoints being analysed, e.g. "Hours"}

\item{GRAPHNAME}{Used internally by the getATestResults method when producing graphs for multiple timepoints. Should not be set in function call.}
}
\description{
Get A-Test results for multiple simulation timepoints
}
