% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robustness_sampling.R
\name{oat_generate_netlogo_behaviour_space_XML}
\alias{oat_generate_netlogo_behaviour_space_XML}
\title{Creates a Netlogo compatible behaviour space experiment for robustness analysis}
\usage{
oat_generate_netlogo_behaviour_space_XML(FILEPATH, NETLOGO_SETUPFILE_NAME,
  PARAMETERS, PARAMVALS, NETLOGO_SETUP_FUNCTION, NETLOGO_RUN_FUNCTION, MEASURES,
  EXPERIMENT_REPETITIONS, RUNMETRICS_EVERYSTEP)
}
\arguments{
\item{FILEPATH}{Directory where the parameter samples are to be stored}

\item{NETLOGO_SETUPFILE_NAME}{Name to give, or given to, the Netlogo XML experiment file(s) created in sampling. For more than one, a sample number is appended}

\item{PARAMETERS}{Array containing the names of the parameters of which parameter samples will be generated}

\item{PARAMVALS}{Array containing either the parameter value (if not of interest in the analysis), or range under which this is being explored (stated as as string e.g. "[5,50,5]" for a range of 5-50, increment of 5). See tutorial for more detail}

\item{NETLOGO_SETUP_FUNCTION}{The name of the function in Netlogo that sets up the simulation. Commonly is named setup.}

\item{NETLOGO_RUN_FUNCTION}{The name of the function in Netlogo that starts the simulation. Commonly named go.}

\item{MEASURES}{Array containing the names of the Netlogo output measures which are used to analyse the simulation.}

\item{EXPERIMENT_REPETITIONS}{The number of times Netlogo should repeat the experiment for each set of parameter values.}

\item{RUNMETRICS_EVERYSTEP}{Boolean stating whether Netlogo should produce output for each timestep.}
}
\description{
This generates a Netlogo XML Experiment file, to be used with the
BehaviourSpace feature or Headless Netlogo, which perturbs each parameter
over a set value space, altering one parameter at a time in this case
}
