% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aleatory_analysis_plotting.R
\name{aa_graphSampleSizeSummary}
\alias{aa_graphSampleSizeSummary}
\title{Plots a comparison of the maximum A-Test score for each sample size}
\usage{
aa_graphSampleSizeSummary(FILEPATH, MEASURES, MAXSAMPLESIZE, SMALL, MEDIUM,
  LARGE, GRAPHOUTPUTFILE, SAMPLESUMMARY_OBJECT = NULL,
  SAMPLESUMMARY_FILE = NULL, TIMEPOINTS = NULL, TIMEPOINTSCALE = NULL,
  GRAPHLABEL = NULL)
}
\arguments{
\item{FILEPATH}{Directory where the results of the simulation runs, in folders or in single CSV file format, can be found}

\item{MEASURES}{An array containing the names of the simulation output measures to be analysed.}

\item{MAXSAMPLESIZE}{The highest number of samples used.}

\item{SMALL}{The figure (>0.5) which is deemed a "small difference" between two sets being compared.  Vargha-Delaney set this value to 0.56 - but this can be altered here}

\item{MEDIUM}{The figure (>0.5) which is deemed a "medium difference" between two sets being compared.  Vargha-Delaney set this value to 0.66 - but this can be altered here}

\item{LARGE}{The figure (>0.5) which is deemed a "large difference" between two sets being compared.  Vargha-Delaney set this value to 0.73 - but this can be altered here}

\item{GRAPHOUTPUTFILE}{Filename that should be given to the generated summary graph. This must have a PDF file extension}

\item{SAMPLESUMMARY_OBJECT}{The name of an R object in the environment containing the summary A-Test scores for this sample size}

\item{SAMPLESUMMARY_FILE}{The name of the CSV containing the summary A-Test scores for this sample size}

\item{TIMEPOINTS}{Implemented so this method can be used when analysing multiple simulation timepoints. If only analysing one timepoint, this should be set to NULL. If not, this should be an array of timepoints, e.g. c(12,36,48,60)}

\item{TIMEPOINTSCALE}{Implemented so this method can be used when analysing multiple simulation timepoints. Sets the scale of the timepoints being analysed, e.g. "Hours"}

\item{GRAPHLABEL}{Used internally by the \code{getATestResults} method when producing graphs for multiple timepoints. Should not be set in function call}
}
\description{
Produces a full graph of the data generated by \code{aa_sampleSize_Summary}
(by full, we mean the y-axis (the A-Test score) goes from 0-1, and the
x axis contains all sample sizes examined), making it easy to see how
uncertainty reduces with an increase in sample size. This graph is named
as stated in the parameter GRAPHOUTPUTFILE, with the timepoint appended
if the analysis is for multiple timepoints.
}
