lhc_generateLHCSummary <-
function(FILEPATH,LHC_PARAM_CSV_LOCATION,PARAMETERS,NUMSAMPLES,MEASURES,MEDIANSFILENAME,LHCSUMMARYFILENAME)
{
	# LHCSUMMARYFILENAME IS LHCSummary.csv for 1 timepoint
	# READ IN THE LHC DESIGN TABLE - NEED TO REFER TO THIS LATER AS PARAMETERS ARE LISTED WITH THE MEDIAN RESULT SET
	lhcTable<-read.csv(LHC_PARAM_CSV_LOCATION,header=TRUE)
	
	# SUMMARY TABLE WILL STORE THE PARAMETERS USED IN THE RUN SET, AND THE MEDIAN OUTPUT MEASURES, FOR EACH SET	
	summaryTable<-NULL	

	# NOW GO THROUGH EACH PARAMETER SUBSET GENERATED BY THE LHC
	for(j in 1:NUMSAMPLES)
	{
		# GET THE PARAMETERS USED FOR THIS SET OF RUNS
		paramRow<-NULL
		paramRow <- t(as.numeric(lhcTable[j,]))

		# STORE IN A NEW VECTOR, RESULTS WILL BE ADDED TO THIS
		summaryOutputRow<-NULL		
		
		# GET THE MEDIAN MODEL RESULTS
		fileAddress = paste(FILEPATH,"/",j,"/",MEDIANSFILENAME,sep="")
		if(file.exists(fileAddress))
		{
			modelResult<-read.csv(fileAddress)

			# NOW GET THE MEDIAN OF ALL RUNS PERFORMED FOR THIS SUBSET
			mediansForAllMeasures<-NULL

			# NOW GET THE MEDIANS FOR EACH MEASURE
			for(l in 1:length(MEASURES))
			{
				measureMedian <- median(modelResult[MEASURES[l]][,1])
				mediansForAllMeasures<-cbind(mediansForAllMeasures,measureMedian)
			}
			summaryOutputRow<-cbind(paramRow,mediansForAllMeasures)
			summaryTable<-rbind(summaryTable,summaryOutputRow)
		}
	}

	# WRITE OUT THE SUMMARY FILE
	if(!is.null(summaryTable))
	{
		outputColHeaders<-cbind(t(PARAMETERS),t(MEASURES))
		colnames(summaryTable)<-outputColHeaders
		summaryResultsFile<-paste(FILEPATH,"/",LHCSUMMARYFILENAME,sep="")
		write.csv(summaryTable,summaryResultsFile,quote = FALSE,row.names=FALSE)
	}
	
}

